/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.item.ITeleposerFocus;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.tile.container.ContainerTeleposer;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class TileTeleposer
extends TileInventory
implements ITickableTileEntity,
INamedContainerProvider,
ICommandSource {
    @ObjectHolder(value="bloodmagic:teleposer")
    public static TileEntityType<TileTeleposer> TYPE;
    int previousInput = 0;
    public static final int FOCUS_SLOT = 0;
    public static final int MAX_UNIT_COST = 1000;
    public static final int MAX_TOTAL_COST = 10000;

    public TileTeleposer(TileEntityType<?> type) {
        super(type, 1, "teleposer");
    }

    public TileTeleposer() {
        this(TYPE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int currentInput = this.func_145831_w().func_175676_y(this.field_174879_c);
        if (this.previousInput == 0 && currentInput != 0) {
            this.previousInput = currentInput;
            this.initiateTeleport();
        } else {
            this.previousInput = currentInput;
        }
    }

    public void initiateTeleport() {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        if (!this.canTeleport()) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
        ItemStack focusStack = this.func_70301_a(0);
        ITeleposerFocus focusItem = (ITeleposerFocus)focusStack.func_77973_b();
        World linkedWorld = focusItem.getStoredWorld(focusStack, this.field_145850_b);
        BlockPos linkedPos = focusItem.getStoredPos(focusStack);
        if (linkedWorld == null || linkedPos.equals((Object)this.field_174879_c)) {
            return;
        }
        RegistryKey linkedKey = linkedWorld.func_234923_W_();
        TileEntity boundTile = linkedWorld.func_175625_s(linkedPos);
        if (boundTile instanceof TileTeleposer) {
            Vector3d newPosVec;
            AxisAlignedBB entityRangeOffsetBB = focusItem.getEntityRangeOffset(linkedWorld, this.func_174877_v());
            if (entityRangeOffsetBB == null) {
                return;
            }
            double transportCost = Math.min(0.5 * Math.sqrt(linkedPos.func_177951_i((Vector3i)this.field_174879_c)), 1000.0);
            if (!linkedWorld.equals(this.field_145850_b)) {
                transportCost = 1000.0;
            }
            AxisAlignedBB originalBB = entityRangeOffsetBB.func_186670_a(this.func_174877_v());
            AxisAlignedBB focusBB = entityRangeOffsetBB.func_186670_a(linkedPos);
            List originalEntities = this.field_145850_b.func_217357_a(Entity.class, originalBB);
            List focusEntities = this.field_145850_b.func_217357_a(Entity.class, focusBB);
            List<BlockPos> offsetList = focusItem.getBlockListOffset(this.field_145850_b);
            int uses = 0;
            int maxUses = offsetList.size() + originalEntities.size() + focusEntities.size();
            int maxDrain = Math.min((int)(transportCost * (double)maxUses), 10000);
            SoulNetwork network = this.getNetwork();
            if (network.getCurrentEssence() < maxDrain) {
                return;
            }
            for (Entity entity : originalEntities) {
                newPosVec = entity.func_213303_ch().func_178786_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()).func_72441_c((double)linkedPos.func_177958_n(), (double)linkedPos.func_177956_o(), (double)linkedPos.func_177952_p());
                if (entity instanceof PlayerEntity && !linkedWorld.equals(this.field_145850_b)) {
                    this.teleportPlayerToLocation(serverWorld, (PlayerEntity)entity, (RegistryKey<World>)linkedKey, newPosVec.field_72450_a, newPosVec.field_72448_b, newPosVec.field_72449_c);
                } else {
                    entity.func_70634_a(newPosVec.field_72450_a, newPosVec.field_72448_b, newPosVec.field_72449_c);
                    entity.func_70029_a(linkedWorld);
                }
                ++uses;
            }
            for (Entity entity : focusEntities) {
                newPosVec = entity.func_213303_ch().func_72441_c((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()).func_178786_a((double)linkedPos.func_177958_n(), (double)linkedPos.func_177956_o(), (double)linkedPos.func_177952_p());
                if (entity instanceof PlayerEntity && !linkedWorld.equals(this.field_145850_b)) {
                    this.teleportPlayerToLocation(serverWorld, (PlayerEntity)entity, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), newPosVec.field_72450_a, newPosVec.field_72448_b, newPosVec.field_72449_c);
                } else {
                    entity.func_70634_a(newPosVec.field_72450_a, newPosVec.field_72448_b, newPosVec.field_72449_c);
                    entity.func_70029_a(this.field_145850_b);
                }
                ++uses;
            }
            for (BlockPos offsetPos : offsetList) {
                BlockPos focusPos;
                BlockPos originalPos = this.field_174879_c.func_177971_a((Vector3i)offsetPos);
                if (!Utils.swapLocations(this.field_145850_b, originalPos, linkedWorld, focusPos = linkedPos.func_177971_a((Vector3i)offsetPos), false)) continue;
                ++uses;
            }
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
            linkedWorld.func_184148_a(null, (double)linkedPos.func_177958_n(), (double)linkedPos.func_177956_o(), (double)linkedPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
            network.syphon(SoulTicket.block(this.field_145850_b, this.field_174879_c, Math.min((int)((double)uses * transportCost), 10000)));
        }
    }

    public boolean canTeleport() {
        SoulNetwork network = this.getNetwork();
        return network != null;
    }

    private SoulNetwork getNetwork() {
        ItemStack focusStack = this.func_70301_a(0);
        if (!focusStack.func_190926_b() && focusStack.func_77973_b() instanceof ITeleposerFocus) {
            return NetworkHelper.getSoulNetwork(((ITeleposerFocus)focusStack.func_77973_b()).getBinding(focusStack));
        }
        return null;
    }

    @Override
    public void deserialize(CompoundNBT tagCompound) {
        super.deserialize(tagCompound);
        this.previousInput = tagCompound.func_74762_e("redstone");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tagCompound) {
        super.serialize(tagCompound);
        tagCompound.func_74768_a("redstone", this.previousInput);
        return tagCompound;
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerTeleposer(this, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Teleposer");
    }

    public CommandSource getCommandSource(ServerWorld world) {
        return new CommandSource((ICommandSource)this, new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()), Vector2f.field_189974_a, world, 2, "Teleposer", (ITextComponent)new StringTextComponent("Teleposer"), world.func_73046_m(), (Entity)null);
    }

    public void teleportPlayerToLocation(ServerWorld serverWorld, PlayerEntity player, RegistryKey<World> destination, double x, double y, double z) {
        String command = this.getTextCommandForTeleport(destination, player, x, y, z);
        MinecraftServer mcServer = serverWorld.func_73046_m();
        mcServer.func_195571_aL().func_197059_a(this.getCommandSource(serverWorld), command);
    }

    public String getTextCommandForTeleport(RegistryKey<World> destination, PlayerEntity player, double posX, double posY, double posZ) {
        String playerName = player.func_200200_C_().getString();
        return "execute in " + destination.func_240901_a_().toString() + " run teleport " + playerName + " " + posX + " " + posY + " " + posZ;
    }

    public void func_145747_a(ITextComponent component, UUID senderUUID) {
    }

    public boolean func_195039_a() {
        return false;
    }

    public boolean func_195040_b() {
        return false;
    }

    public boolean func_195041_r_() {
        return false;
    }
}

