/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile.routing;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Triple;
import wayoftime.bloodmagic.common.routing.IItemRoutingNode;
import wayoftime.bloodmagic.common.routing.IMasterRoutingNode;
import wayoftime.bloodmagic.common.routing.IRoutingNode;
import wayoftime.bloodmagic.tile.TileInventory;

public class TileRoutingNode
extends TileInventory
implements IRoutingNode,
IItemRoutingNode,
ITickableTileEntity {
    @ObjectHolder(value="bloodmagic:itemroutingnode")
    public static TileEntityType<TileRoutingNode> TYPE;
    private int currentInput;
    private BlockPos masterPos = BlockPos.field_177992_a;
    private List<BlockPos> connectionList = new LinkedList<BlockPos>();
    private AxisAlignedBB boundingBox;

    public TileRoutingNode(TileEntityType<?> type, int size, String name) {
        super(type, size, name);
    }

    public TileRoutingNode() {
        this(TYPE, 1, "routingnode");
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.currentInput = this.func_145831_w().func_175687_A(this.field_174879_c);
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        CompoundNBT masterTag = new CompoundNBT();
        masterTag.func_74768_a("xCoord", this.masterPos.func_177958_n());
        masterTag.func_74768_a("yCoord", this.masterPos.func_177956_o());
        masterTag.func_74768_a("zCoord", this.masterPos.func_177952_p());
        tag.func_218657_a("master", (INBT)masterTag);
        ListNBT tags = new ListNBT();
        for (BlockPos pos : this.connectionList) {
            CompoundNBT posTag = new CompoundNBT();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.add((Object)posTag);
        }
        tag.func_218657_a("connections", (INBT)tags);
        return tag;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.connectionList.clear();
        CompoundNBT masterTag = tag.func_74775_l("master");
        this.masterPos = new BlockPos(masterTag.func_74762_e("xCoord"), masterTag.func_74762_e("yCoord"), masterTag.func_74762_e("zCoord"));
        ListNBT tags = tag.func_150295_c("connections", 10);
        for (int i = 0; i < tags.size(); ++i) {
            CompoundNBT blockTag = tags.func_150305_b(i);
            BlockPos newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.connectionList.add(newPos);
        }
    }

    @Override
    public void removeAllConnections() {
        TileEntity testTile = this.func_145831_w().func_175625_s(this.getMasterPos());
        if (testTile instanceof IMasterRoutingNode) {
            ((IMasterRoutingNode)testTile).removeConnection(this.field_174879_c);
        }
        for (BlockPos testPos : this.connectionList) {
            TileEntity tile = this.func_145831_w().func_175625_s(testPos);
            if (!(tile instanceof IRoutingNode)) continue;
            ((IRoutingNode)tile).removeConnection(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(testPos), this.func_145831_w().func_180495_p(testPos), 3);
        }
        this.connectionList.clear();
    }

    @Override
    public void connectMasterToRemainingNode(World world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
        this.masterPos = master.getCurrentBlockPos();
        List<BlockPos> connectedList = this.getConnected();
        for (BlockPos testPos : connectedList) {
            IRoutingNode node;
            if (alreadyChecked.contains(testPos)) continue;
            alreadyChecked.add(testPos);
            TileEntity tile = world.func_175625_s(testPos);
            if (!(tile instanceof IRoutingNode) || !(node = (IRoutingNode)tile).getMasterPos().equals((Object)BlockPos.field_177992_a)) continue;
            master.addNodeToList(node);
            node.connectMasterToRemainingNode(world, alreadyChecked, master);
        }
        master.addConnections(this.getCurrentBlockPos(), connectedList);
    }

    @Override
    public Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckConnectionToMaster(List<BlockPos> alreadyChecked, List<IRoutingNode> nodeList) {
        if (this.masterPos.equals((Object)BlockPos.field_177992_a)) {
            return Triple.of((Object)false, alreadyChecked, nodeList);
        }
        List<BlockPos> connectedList = this.getConnected();
        for (BlockPos testPos : connectedList) {
            if (alreadyChecked.contains(testPos)) continue;
            alreadyChecked.add(testPos);
            TileEntity tile = this.field_145850_b.func_175625_s(testPos);
            if (!(tile instanceof IRoutingNode)) continue;
            IRoutingNode node = (IRoutingNode)tile;
            if (node instanceof IMasterRoutingNode) {
                return Triple.of((Object)true, alreadyChecked, nodeList);
            }
            Triple<Boolean, List<BlockPos>, List<IRoutingNode>> checkResult = node.recheckConnectionToMaster(alreadyChecked, nodeList);
            if (!((Boolean)checkResult.getLeft()).booleanValue()) continue;
            return checkResult;
        }
        nodeList.add(this);
        return Triple.of((Object)false, alreadyChecked, nodeList);
    }

    @Override
    public List<BlockPos> checkAndPurgeConnectionToMaster(BlockPos ignorePos) {
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        posList.add(ignorePos);
        Triple<Boolean, List<BlockPos>, List<IRoutingNode>> recheckResult = this.recheckConnectionToMaster(posList, new LinkedList<IRoutingNode>());
        if (!((Boolean)recheckResult.getLeft()).booleanValue()) {
            TileEntity testTile = this.field_145850_b.func_175625_s(this.masterPos);
            IMasterRoutingNode masterNode = null;
            if (testTile instanceof IMasterRoutingNode) {
                masterNode = (IMasterRoutingNode)testTile;
                masterNode.removeConnection(this.getCurrentBlockPos());
            }
            for (IRoutingNode node : (List)recheckResult.getRight()) {
                BlockPos masterPos = node.getMasterPos();
                node.removeConnection(masterPos);
                if (masterNode == null) continue;
                masterNode.removeConnection(node.getCurrentBlockPos());
            }
            return (List)recheckResult.getMiddle();
        }
        return (List)recheckResult.getMiddle();
    }

    @Override
    public BlockPos getCurrentBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<BlockPos> getConnected() {
        return this.connectionList;
    }

    @Override
    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        BlockPos checkPos = master.getCurrentBlockPos();
        return checkPos.equals((Object)this.getMasterPos());
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addConnection(BlockPos pos1) {
        if (!this.connectionList.contains(pos1)) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.connectionList.add(pos1);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        if (this.connectionList.contains(pos1)) {
            this.connectionList.remove(pos1);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
        if (pos1.equals((Object)this.masterPos)) {
            this.masterPos = BlockPos.field_177992_a;
        }
    }

    @Override
    public boolean isInventoryConnectedToSide(Direction side) {
        return false;
    }

    @Override
    public int getPriority(Direction side) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 10000.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = super.getRenderBoundingBox().func_186662_g(5.0);
        }
        return this.boundingBox;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }
}

