/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.source.orbital;

import hellfirepvp.astralsorcery.client.effect.EffectProperties;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.source.FXSourceOrbital;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.Function;

public class FXOrbitalCrystalAttunement
extends FXSourceOrbital<FXFacingParticle, BatchRenderContext<FXFacingParticle>> {
    private final Vector3 targetPoint;
    private final IConstellation cst;

    public FXOrbitalCrystalAttunement(Vector3 pos, Vector3 floatTarget, IConstellation constellation) {
        super(pos, EffectTemplatesAS.GENERIC_PARTICLE);
        this.targetPoint = floatTarget.clone();
        this.cst = constellation;
    }

    @Override
    public void spawnOrbitalParticle(Vector3 pos, Function<Vector3, FXFacingParticle> effectRegistrar) {
        Vector3 motion = this.getPosition().subtract(pos).crossProduct(this.getOrbitAxis()).normalize().multiply(0.1 + (double)rand.nextFloat() * 0.1);
        motion.add(this.getOrbitAxis().normalize().multiply(0.15 + (double)rand.nextFloat() * 0.15));
        Vector3 vortexPos = pos.clone();
        MiscUtils.applyRandomOffset(vortexPos, rand, 0.4f);
        FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)effectRegistrar.apply(vortexPos).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setAlphaMultiplier(0.75f)).alpha(VFXAlphaFunction.proximity(this.targetPoint::clone, 3.0f))).motion(VFXMotionController.target(this.targetPoint::clone, 0.075f))).setMotion(motion)).setMaxAge(60);
        if (rand.nextInt(3) == 0) {
            p.color(VFXColorFunction.constant(this.cst.getConstellationColor()));
        }
    }

    @Override
    public void populateProperties(EffectProperties<FXFacingParticle> properties) {
    }
}

