/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.client.util.SphereBuilder;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class FXColorEffectSphere
extends EntityVisualFX {
    private double alphaFadeMaxDist = -1.0;
    private boolean removeIfInvisible = false;
    private List<SphereBuilder.TriangleFace> sphereFaces = new LinkedList<SphereBuilder.TriangleFace>();

    public FXColorEffectSphere(Vector3 pos) {
        super(pos);
    }

    public FXColorEffectSphere setupSphere(Vector3 axis, float scale) {
        return this.setupSphere(axis, scale, 8, 10);
    }

    public FXColorEffectSphere setupSphere(Vector3 axis, float scale, int fractionsSplit, int fractionsCircle) {
        this.setScaleMultiplier(scale);
        Vector3 actAxis = axis.clone().normalize().multiply(scale);
        fractionsSplit = MathHelper.func_76125_a((int)fractionsSplit, (int)2, (int)Integer.MAX_VALUE);
        fractionsCircle = MathHelper.func_76125_a((int)fractionsCircle, (int)3, (int)Integer.MAX_VALUE);
        this.sphereFaces = SphereBuilder.buildFaces(actAxis, fractionsSplit, fractionsCircle);
        return this;
    }

    public FXColorEffectSphere setAlphaFadeDistance(double fadeDistance) {
        if (fadeDistance > 0.0) {
            this.alphaFadeMaxDist = fadeDistance;
            this.alpha((fx, alpha, pTicks) -> {
                Entity rView = Minecraft.func_71410_x().func_175606_aa();
                if (rView == null) {
                    rView = Minecraft.func_71410_x().field_71439_g;
                }
                Vector3 plVec = Vector3.atEntityCenter(rView);
                double dst = plVec.distance(this.getRenderPosition(pTicks)) - 1.2;
                alpha = (float)((double)alpha * (1.0 - dst / this.alphaFadeMaxDist));
                alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
                return alpha;
            });
        } else {
            this.alpha(VFXAlphaFunction.CONSTANT);
        }
        return this;
    }

    public FXColorEffectSphere setRemoveIfInvisible(boolean removeIfInvisible) {
        this.removeIfInvisible = removeIfInvisible;
        return this;
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
        int alpha = this.getAlpha(pTicks);
        if (this.removeIfInvisible && alpha <= 0) {
            this.requestRemoval();
            return;
        }
        Color c = this.getColor(pTicks);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        Matrix4f matr = renderStack.func_227866_c_().func_227870_a_();
        Vector3 pos = this.getRenderPosition(pTicks);
        pos.subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
        for (SphereBuilder.TriangleFace face : this.sphereFaces) {
            pos.clone().add(face.getV1()).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_181675_d();
            pos.clone().add(face.getV2()).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_181675_d();
            pos.clone().add(face.getV3()).drawPos(matr, vb).func_225586_a_(r, g, b, alpha).func_181675_d();
        }
    }
}

