/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityDynamicFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.LightmapUtil;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3f;

public class FXCube
extends EntityVisualFX
implements EntityDynamicFX {
    private TextureAtlasSprite tas = null;
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();
    private float tumbleIntensityMultiplier = 1.0f;
    private float textureSubSizePercentage = 1.0f;

    public FXCube(Vector3 pos) {
        super(pos);
    }

    public FXCube setTextureAtlasSprite(TextureAtlasSprite tas) {
        this.tas = tas;
        return this;
    }

    public FXCube setTextureSubSizePercentage(float textureSubSizePercentage) {
        this.textureSubSizePercentage = textureSubSizePercentage;
        return this;
    }

    public FXCube setTumbleIntensityMultiplier(float tumbleIntensityMultiplier) {
        this.tumbleIntensityMultiplier = tumbleIntensityMultiplier;
        return this;
    }

    public FXCube tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(12);
        return this;
    }

    public Vector3 getInterpolatedRotation(float pTicks) {
        return new Vector3(RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), pTicks), RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), pTicks), RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), pTicks));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tumbleIntensityMultiplier > 0.0f && this.rotationChange.lengthSquared() > 0.0) {
            Vector3 degAxis = this.rotationDegreeAxis.clone();
            Vector3 modify = this.rotationChange.clone().multiply(this.tumbleIntensityMultiplier);
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(modify);
            Vector3 newDegAxis = this.rotationDegreeAxis;
            newDegAxis.setX(newDegAxis.getX() % 360.0).setY(newDegAxis.getY() % 360.0).setZ(newDegAxis.getZ() % 360.0);
            if (!degAxis.add(modify).equals(newDegAxis)) {
                this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone().subtract(modify);
            }
        } else {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
        }
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
    }

    @Override
    public <T extends EntityVisualFX> void renderNow(BatchRenderContext<T> ctx, MatrixStack renderStack, IDrawRenderTypeBuffer drawBuffer, float pTicks) {
        float vLength;
        float uLength;
        float v;
        float u;
        if (this.tas != null) {
            u = this.tas.func_94209_e();
            v = this.tas.func_94206_g();
            uLength = (this.tas.func_94212_f() - u) * this.textureSubSizePercentage;
            vLength = (this.tas.func_94210_h() - v) * this.textureSubSizePercentage;
        } else {
            SpriteSheetResource ssr = ctx.getSprite();
            Tuple<Float, Float> uv = ssr.getUVOffset(this.getAge());
            u = ((Float)uv.func_76341_a()).floatValue();
            v = ((Float)uv.func_76340_b()).floatValue();
            uLength = ssr.getULength() * this.textureSubSizePercentage;
            vLength = ssr.getVLength() * this.textureSubSizePercentage;
        }
        int alpha = this.getAlpha(pTicks);
        Color c = this.getColor(pTicks);
        Vector3 translateTo = this.getRenderPosition(pTicks).subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
        Vector3 rotation = this.getInterpolatedRotation(pTicks);
        float scale = this.getScale(pTicks);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(translateTo.getX(), translateTo.getY(), translateTo.getZ());
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotation.getX()));
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation.getY()));
        renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)rotation.getZ()));
        renderStack.func_227862_a_(scale, scale, scale);
        IVertexBuilder buf = drawBuffer.getBuffer(ctx.getRenderType());
        RenderingDrawUtils.renderTexturedCubeCentralColorLighted(buf, renderStack, u, v, uLength, vLength, c.getRed(), c.getGreen(), c.getBlue(), alpha, LightmapUtil.getPackedFullbrightCoords());
        renderStack.func_227865_b_();
    }
}

