/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource.query;

import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.query.TextureQuery;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextureSubQuery
extends TextureQuery {
    private final float uOffset;
    private final float vOffset;
    private final float uLength;
    private final float vLength;

    public TextureSubQuery(AssetLoader.TextureLocation location, String name, float uOffset, float vOffset, float uLength, float vLength) {
        super(location, name);
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uLength = uLength;
        this.vLength = vLength;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AbstractRenderableTexture resolve() {
        final AbstractRenderableTexture res = super.resolve();
        return new AbstractRenderableTexture(res.getKey()){

            @Override
            public void bindTexture() {
                res.bindTexture();
            }

            @Override
            public RenderState.TextureState asState() {
                return res.asState();
            }

            @Override
            public Tuple<Float, Float> getUVOffset() {
                return new Tuple((Object)Float.valueOf(TextureSubQuery.this.uOffset), (Object)Float.valueOf(TextureSubQuery.this.vOffset));
            }

            @Override
            public float getUWidth() {
                return TextureSubQuery.this.uLength;
            }

            @Override
            public float getVWidth() {
                return TextureSubQuery.this.vLength;
            }

            @Override
            public boolean equals(Object obj) {
                return res.equals(obj);
            }

            @Override
            public int hashCode() {
                return res.hashCode();
            }
        };
    }
}

