/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.advancement.instance;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ConstellationInstance
extends CriterionInstance {
    private boolean constellationMajor = false;
    private boolean constellationWeak = false;
    private boolean constellationMinor = false;
    private final Set<IConstellation> constellations = new HashSet<IConstellation>();

    private ConstellationInstance(ResourceLocation id) {
        super(id, EntityPredicate.AndPredicate.field_234582_a_);
    }

    public static ConstellationInstance any(ResourceLocation type) {
        return new ConstellationInstance(type);
    }

    public static ConstellationInstance anyMajor(ResourceLocation type) {
        ConstellationInstance instance = new ConstellationInstance(type);
        instance.constellationMajor = true;
        return instance;
    }

    public static ConstellationInstance anyWeak(ResourceLocation type) {
        ConstellationInstance instance = new ConstellationInstance(type);
        instance.constellationWeak = true;
        return instance;
    }

    public static ConstellationInstance anyMinor(ResourceLocation type) {
        ConstellationInstance instance = new ConstellationInstance(type);
        instance.constellationMinor = true;
        return instance;
    }

    public static ConstellationInstance anyOf(ResourceLocation type, IConstellation ... cst) {
        ConstellationInstance instance = new ConstellationInstance(type);
        instance.constellations.addAll(Arrays.asList(cst));
        return instance;
    }

    public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
        JsonObject out = super.func_230240_a_(conditions);
        if (this.constellationMajor) {
            out.addProperty("major", Boolean.valueOf(true));
        }
        if (this.constellationWeak) {
            out.addProperty("weak", Boolean.valueOf(true));
        }
        if (this.constellationMinor) {
            out.addProperty("minor", Boolean.valueOf(true));
        }
        if (!this.constellations.isEmpty()) {
            JsonArray names = new JsonArray();
            for (IConstellation cst : this.constellations) {
                names.add(cst.getRegistryName().toString());
            }
            out.add("constellations", (JsonElement)names);
        }
        return out;
    }

    public static ConstellationInstance deserialize(ResourceLocation id, JsonObject json) {
        ConstellationInstance instance = new ConstellationInstance(id);
        instance.constellationMajor = JSONUtils.func_151209_a((JsonObject)json, (String)"major", (boolean)false);
        instance.constellationWeak = JSONUtils.func_151209_a((JsonObject)json, (String)"weak", (boolean)false);
        instance.constellationMinor = JSONUtils.func_151209_a((JsonObject)json, (String)"minor", (boolean)false);
        JsonArray constellationNames = JSONUtils.func_151213_a((JsonObject)json, (String)"constellations", (JsonArray)new JsonArray());
        for (int idx = 0; idx < constellationNames.size(); ++idx) {
            JsonElement element = constellationNames.get(idx);
            String key = JSONUtils.func_151206_a((JsonElement)element, (String)String.format("constellations[%s]", idx));
            IConstellation cst = (IConstellation)RegistriesAS.REGISTRY_CONSTELLATIONS.getValue(new ResourceLocation(key));
            if (cst == null) {
                throw new IllegalArgumentException(String.format("Unknown constellation: %s - at constellations[%s]", key, idx));
            }
            instance.constellations.add(cst);
        }
        return instance;
    }

    public boolean test(IConstellation discovered) {
        if (this.constellationMajor && !(discovered instanceof IMajorConstellation)) {
            return false;
        }
        if (this.constellationWeak && (!(discovered instanceof IWeakConstellation) || discovered instanceof IMajorConstellation)) {
            return false;
        }
        if (this.constellationMinor && !(discovered instanceof IMinorConstellation)) {
            return false;
        }
        return this.constellations.isEmpty() || this.constellations.contains(discovered);
    }
}

