/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.book;

import hellfirepvp.astralsorcery.common.auxiliary.book.BookLookupInfo;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.item.ItemComparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.LogicalSide;

public class BookLookupRegistry {
    private static final Map<ItemStack, BookLookupInfo> lookupMap = new HashMap<ItemStack, BookLookupInfo>();

    private BookLookupRegistry() {
    }

    @Nullable
    public static BookLookupInfo findPage(PlayerEntity player, LogicalSide side, ItemStack search) {
        for (ItemStack compare : lookupMap.keySet()) {
            PlayerProgress prog;
            BookLookupInfo info;
            if (!ItemComparator.compare(compare, search, ItemComparator.Clause.Sets.ITEMSTACK_CRAFTING) || !(info = lookupMap.get(compare)).canSee(prog = ResearchHelper.getProgress(player, side))) continue;
            return info;
        }
        return null;
    }

    public static void registerItemLookup(IItemProvider item, ResearchNode parentNode, int nodePage, ResearchProgression neededProgression) {
        BookLookupRegistry.registerItemLookup(new ItemStack(item), parentNode, nodePage, neededProgression);
    }

    public static void registerItemLookup(ItemStack stack, ResearchNode parentNode, int nodePage, ResearchProgression neededProgression) {
        lookupMap.put(stack, new BookLookupInfo(parentNode, nodePage, neededProgression));
    }
}

