/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base.patreon.types;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.base.patreon.FlareColor;
import hellfirepvp.astralsorcery.common.base.patreon.PatreonEffect;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class TypeNebulaCloud
extends PatreonEffect
implements ITickHandler {
    private final UUID playerUUID;

    public TypeNebulaCloud(UUID effectUUID, @Nullable FlareColor flareColor, UUID playerUUID) {
        super(effectUUID, flareColor);
        this.playerUUID = playerUUID;
    }

    @Override
    public void attachTickListeners(Consumer<ITickHandler> registrar) {
        super.attachTickListeners(registrar);
        registrar.accept(this);
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        if (side.isClient() && this.shouldDoEffect(player)) {
            this.spawnCloudParticles(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnCloudParticles(PlayerEntity player) {
        Vector3 playerPos = Vector3.atEntityCorner((Entity)player).addY(0.1f);
        for (int i = 0; i < 3; ++i) {
            float oX = (rand.nextFloat() - rand.nextFloat()) * 2.0f;
            float oZ = (rand.nextFloat() - rand.nextFloat()) * 2.0f;
            Vector3 offset = new Vector3(oX, rand.nextFloat() * 0.1f, oZ);
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(playerPos.clone().add(offset))).setAlphaMultiplier(0.8f)).alpha(((VFXAlphaFunction<EntityVisualFX>)(fx, alphaIn, pTicks) -> {
                if (this.shouldDoEffect(player) && Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() && player.field_70125_A > 40.0f) {
                    return MathHelper.func_76131_a((float)(1.0f - (player.field_70125_A - 40.0f) / 20.0f), (float)0.0f, (float)1.0f) * alphaIn;
                }
                return alphaIn;
            }).andThen(VFXAlphaFunction.FADE_OUT))).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.3f)).setMaxAge(40 + rand.nextInt(20));
        }
        if (rand.nextInt(16) == 0) {
            Vector3 from = Vector3.random().setY(0).normalize().multiply(rand.nextFloat() * 2.0f).addY(rand.nextFloat() * 0.1f);
            Vector3 to = Vector3.random().setY(0).normalize().multiply(rand.nextFloat() * 2.0f).addY(rand.nextFloat() * 0.1f);
            ((EntityVisualFX)((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(playerPos.clone().add(from))).makeDefault(playerPos.clone().add(to)).color(VFXColorFunction.WHITE)).alpha((fx, alphaIn, pTicks) -> {
                if (this.shouldDoEffect(player) && Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() && player.field_70125_A > 40.0f) {
                    return MathHelper.func_76131_a((float)(1.0f - (Math.abs(player.field_70125_A) - 40.0f) / 20.0f), (float)0.0f, (float)1.0f) * alphaIn;
                }
                return alphaIn;
            });
        }
    }

    private boolean shouldDoEffect(PlayerEntity player) {
        return player.func_110124_au().equals(this.playerUUID) && (player.func_213283_Z() == Pose.STANDING || player.func_213283_Z() == Pose.CROUCHING) && !player.func_70644_a(Effects.field_76441_p);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PatreonEffect - Nebula Cloud " + this.playerUUID.toString();
    }
}

