/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import hellfirepvp.astralsorcery.common.block.base.BlockDynamicColor;
import hellfirepvp.astralsorcery.common.block.base.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.block.base.CustomItemBlock;
import hellfirepvp.astralsorcery.common.block.properties.PropertiesGlass;
import hellfirepvp.astralsorcery.common.item.block.ItemBlockPrism;
import hellfirepvp.astralsorcery.common.item.lens.LensColorType;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.tile.TilePrism;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockPrism
extends BlockStarlightNetwork
implements CustomItemBlock,
BlockDynamicColor {
    private static final VoxelShape PRISM_DOWN = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125);
    private static final VoxelShape PRISM_UP = VoxelShapes.func_197873_a((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    private static final VoxelShape PRISM_NORTH = VoxelShapes.func_197873_a((double)0.1875, (double)0.1875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.875);
    private static final VoxelShape PRISM_SOUTH = VoxelShapes.func_197873_a((double)0.1875, (double)0.1875, (double)0.125, (double)0.8125, (double)0.8125, (double)1.0);
    private static final VoxelShape PRISM_EAST = VoxelShapes.func_197873_a((double)0.125, (double)0.1875, (double)0.1875, (double)1.0, (double)0.8125, (double)0.8125);
    private static final VoxelShape PRISM_WEST = VoxelShapes.func_197873_a((double)0.0, (double)0.1875, (double)0.1875, (double)0.875, (double)0.8125, (double)0.8125);
    public static EnumProperty<Direction> PLACED_AGAINST = EnumProperty.func_177709_a((String)"against", Direction.class);
    public static BooleanProperty HAS_COLORED_LENS = BooleanProperty.func_177716_a((String)"has_lens");

    public BlockPrism() {
        super(PropertiesGlass.coatedGlass().harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PLACED_AGAINST, (Comparable)Direction.DOWN)).func_206870_a((Property)HAS_COLORED_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Class<? extends BlockItem> getItemBlockClass() {
        return ItemBlockPrism.class;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TilePrism lens = MiscUtils.getTileAt((IBlockReader)world, pos, TilePrism.class, true);
        if (lens != null && !world.func_201670_d() && !player.func_184812_l_() && lens.getColorType() != null) {
            ItemStack drop = lens.getColorType().getStack();
            ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TilePrism lens;
        if (!world.func_201670_d() && player.func_225608_bj_() && (lens = MiscUtils.getTileAt((IBlockReader)world, pos, TilePrism.class, true)) != null && lens.getColorType() != null) {
            ItemStack drop = lens.getColorType().getStack();
            if (!player.func_184812_l_()) {
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, drop);
                } else if (!player.field_71071_by.func_70441_a(drop)) {
                    ItemUtils.dropItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
                }
            }
            SoundHelper.playSoundAround((SoundEvent)SoundsAS.BLOCK_COLOREDLENS_ATTACH, world, (Vector3i)pos, 0.8f, 1.5f);
            lens.setColorType(null);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PLACED_AGAINST, HAS_COLORED_LENS});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(PLACED_AGAINST, (Comparable)context.func_196000_l().func_176734_d());
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(BlockState state, @Nullable IBlockDisplayReader world, @Nullable BlockPos pos, int tintIndex) {
        LensColorType type;
        if (tintIndex != 3) {
            return -1;
        }
        TilePrism prism = MiscUtils.getTileAt((IBlockReader)world, pos, TilePrism.class, false);
        if (prism != null && (type = prism.getColorType()) != null) {
            return type.getColor().getRGB();
        }
        return -1;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b(PLACED_AGAINST)) {
            case UP: {
                return PRISM_UP;
            }
            case NORTH: {
                return PRISM_NORTH;
            }
            case SOUTH: {
                return PRISM_SOUTH;
            }
            case WEST: {
                return PRISM_WEST;
            }
            case EAST: {
                return PRISM_EAST;
            }
        }
        return PRISM_DOWN;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TilePrism();
    }
}

