/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.client.util.MiscPlayEffect;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectMineralis
extends MantleEffect {
    public static MineralisConfig CONFIG = new MineralisConfig();

    public MantleEffectMineralis() {
        super(ConstellationsAS.mineralis);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(EventPriority.LOWEST, this::onBreak);
    }

    private void onBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (ItemMantle.getEffect((LivingEntity)player, ConstellationsAS.mineralis) != null) {
            LogicalSide side;
            LogicalSide logicalSide = side = player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
            if (side.isServer()) {
                float charge = Math.min(AlignmentChargeHandler.INSTANCE.getCurrentCharge(player, side), (float)((Integer)MantleEffectMineralis.CONFIG.chargeCostPerBreak.get()).intValue());
                AlignmentChargeHandler.INSTANCE.drainCharge(player, side, charge, false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.15f);
        if (rand.nextBoolean()) {
            this.playBlockHighlight(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playBlockHighlight(PlayerEntity player) {
        int index;
        BlockState state = null;
        if (!player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            state = ItemUtils.createBlockState(player.func_184586_b(Hand.MAIN_HAND));
        }
        if (!player.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
            state = ItemUtils.createBlockState(player.func_184586_b(Hand.OFF_HAND));
        }
        if (state == null || state.func_177230_c() instanceof AirBlock) {
            return;
        }
        BlockState fState = state;
        BlockPredicate search = (world, pos, foundState) -> foundState == fState;
        List<BlockPos> positions = BlockDiscoverer.searchForBlocksAround(player.func_130014_f_(), player.func_233580_cy_(), (Integer)MantleEffectMineralis.CONFIG.highlightRange.get(), search);
        if (positions.isEmpty()) {
            return;
        }
        int n = index = positions.size() > 10 ? rand.nextInt(positions.size()) : rand.nextInt(10);
        if (index >= positions.size()) {
            return;
        }
        BlockPos at = positions.get(index);
        BlockState displayState = player.func_130014_f_().func_180495_p(at);
        MiscPlayEffect.playSingleBlockTumbleDepthEffect(new Vector3((Vector3i)at).add(0.5, 0.5, 0.5), displayState);
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    public static class MineralisConfig
    extends MantleEffect.Config {
        private final int defaultHighlightRange = 10;
        private final int defaultChargeCostPerBreak = 2;
        public ForgeConfigSpec.IntValue highlightRange;
        public ForgeConfigSpec.IntValue chargeCostPerBreak;

        public MineralisConfig() {
            super("mineralis");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.highlightRange = cfgBuilder.comment("Sets the highlight radius in which the cape effect will search for the block you're holding. Set to 0 to disable this effect.").translation(this.translationKey("range")).defineInRange("range", this.defaultHighlightRange, 0, 32);
            this.chargeCostPerBreak = cfgBuilder.comment("Set the amount alignment charge consumed per block break enhanced by the mantle effect").translation(this.translationKey("chargeCostPerBreak")).defineInRange("chargeCostPerBreak", this.defaultChargeCostPerBreak, 0, 1000);
        }
    }
}

