/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.world;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.world.ConstellationHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DistributionHandler {
    private final WorldContext ctx;
    private final Map<Integer, Map<IConstellation, Float>> dayDistributionMap = Maps.newHashMap();
    private Map<IConstellation, Float> activeDistribution = Maps.newHashMap();
    private int lastRecordedDay = -1;

    DistributionHandler(WorldContext ctx) {
        this.ctx = ctx;
    }

    public void tick(World world) {
        ConstellationHandler cst = this.ctx.getConstellationHandler();
        int tracked = cst.getLastTrackedDay();
        if (this.dayDistributionMap.isEmpty()) {
            this.initialize();
        }
        if (this.lastRecordedDay == tracked) {
            return;
        }
        this.lastRecordedDay = tracked;
        this.updateDistribution(world);
    }

    public float getDistribution(IConstellation cst) {
        return this.activeDistribution.getOrDefault(cst, Float.valueOf(0.0f)).floatValue();
    }

    private void updateDistribution(World world) {
        MoonPhase current = MoonPhase.fromWorld((IWorld)world);
        HashMap<IConstellation, Float> distribution = new HashMap<IConstellation, Float>(this.dayDistributionMap.get(current.ordinal()));
        for (IConstellationSpecialShowup special : ConstellationRegistry.getSpecialShowupConstellations()) {
            if (special.doesShowUp(world, this.lastRecordedDay)) {
                distribution.put(special, Float.valueOf(MathHelper.func_76131_a((float)special.getDistribution(world, this.lastRecordedDay, true), (float)0.0f, (float)1.0f)));
                continue;
            }
            distribution.put(special, Float.valueOf(MathHelper.func_76131_a((float)special.getDistribution(world, this.lastRecordedDay, false), (float)0.0f, (float)1.0f)));
        }
        this.activeDistribution = distribution;
    }

    private void initialize() {
        this.dayDistributionMap.clear();
        for (MoonPhase ph : MoonPhase.values()) {
            this.dayDistributionMap.put(ph.ordinal(), Maps.newHashMap());
        }
        int phaseCount = MoonPhase.values().length;
        for (IConstellation cst : RegistriesAS.REGISTRY_CONSTELLATIONS) {
            if (cst instanceof IWeakConstellation) {
                MoonPhase offsetPhase = this.ctx.getConstellationHandler().getOffset(cst);
                if (offsetPhase == null) {
                    return;
                }
                int offset = offsetPhase.ordinal();
                for (MoonPhase ph : MoonPhase.values()) {
                    int index = (offset + ph.ordinal()) % phaseCount;
                    float distr = this.sineDistance(offset, index);
                    this.dayDistributionMap.get(index).put(cst, Float.valueOf(distr));
                }
                continue;
            }
            for (MoonPhase ph : MoonPhase.values()) {
                this.dayDistributionMap.get(ph.ordinal()).put(cst, Float.valueOf(0.0f));
            }
        }
    }

    private float sineDistance(int dayStart, int dayIn) {
        int phaseCount = MoonPhase.values().length;
        int dist = Math.min(Math.abs(dayStart - dayIn), Math.abs(dayStart - (dayIn + phaseCount)));
        float part = (float)dist / (float)(phaseCount / 2);
        return MathHelper.func_76134_b((float)((float)((double)(part / 2.0f) * Math.PI))) * 0.5f + 0.5f;
    }
}

