/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.container.factory;

import hellfirepvp.astralsorcery.common.container.ContainerObservatory;
import hellfirepvp.astralsorcery.common.container.factory.CustomContainerProvider;
import hellfirepvp.astralsorcery.common.lib.ContainerTypesAS;
import hellfirepvp.astralsorcery.common.tile.TileObservatory;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.IContainerFactory;

public class ContainerObservatoryProvider
extends CustomContainerProvider<ContainerObservatory> {
    private final TileObservatory observatory;

    public ContainerObservatoryProvider(TileObservatory observatory) {
        super(ContainerTypesAS.OBSERVATORY);
        this.observatory = observatory;
    }

    @Override
    protected void writeExtraData(PacketBuffer buf) {
        ByteBufUtils.writePos(buf, this.observatory.func_174877_v());
    }

    @Override
    @Nonnull
    public ContainerObservatory createMenu(int windowId, PlayerInventory plInventory, PlayerEntity player) {
        return new ContainerObservatory(this.observatory, windowId);
    }

    private static ContainerObservatory createFromPacket(int windowId, PlayerInventory plInventory, PacketBuffer data) {
        BlockPos at = ByteBufUtils.readPos(data);
        PlayerEntity player = plInventory.field_70458_d;
        TileObservatory observatory = MiscUtils.getTileAt((IBlockReader)player.func_130014_f_(), at, TileObservatory.class, true);
        return new ContainerObservatory(observatory, windowId);
    }

    public static class Factory
    implements IContainerFactory<ContainerObservatory> {
        public ContainerObservatory create(int windowId, PlayerInventory inv, PacketBuffer data) {
            return ContainerObservatoryProvider.createFromPacket(windowId, inv, data);
        }
    }
}

