/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.lib.IngredientSerializersAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;

public class CrystalIngredient
extends Ingredient {
    private final boolean hasToBeAttuned;
    private final boolean hasToBeCelestial;
    private final boolean canBeAttuned;
    private final boolean canBeCelestialCrystal;

    public CrystalIngredient(boolean hasToBeAttuned, boolean hasToBeCelestial) {
        this(hasToBeAttuned, hasToBeCelestial, true, true);
    }

    public CrystalIngredient(boolean hasToBeAttuned, boolean hasToBeCelestial, boolean canBeAttuned, boolean canBeCelestialCrystal) {
        super(CrystalIngredient.getItems(hasToBeAttuned, hasToBeCelestial, canBeAttuned, canBeCelestialCrystal));
        this.hasToBeAttuned = hasToBeAttuned;
        this.hasToBeCelestial = hasToBeCelestial;
        this.canBeAttuned = canBeAttuned;
        this.canBeCelestialCrystal = canBeCelestialCrystal;
    }

    private static Stream<Ingredient.IItemList> getItems(boolean hasToBeAttuned, boolean hasToBeCelestial, boolean canBeAttuned, boolean canBeCelestialCrystal) {
        if (hasToBeAttuned) {
            canBeAttuned = true;
        }
        if (hasToBeCelestial) {
            canBeCelestialCrystal = true;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (hasToBeAttuned) {
            if (hasToBeCelestial) {
                stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL));
            } else {
                stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_ROCK_CRYSTAL));
                if (canBeCelestialCrystal) {
                    stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL));
                }
            }
        } else if (hasToBeCelestial) {
            stacks.add(new ItemStack((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL));
            if (canBeAttuned) {
                stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL));
            }
        } else {
            stacks.add(new ItemStack((IItemProvider)ItemsAS.ROCK_CRYSTAL));
            if (canBeCelestialCrystal) {
                stacks.add(new ItemStack((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL));
            }
            if (canBeAttuned) {
                stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_ROCK_CRYSTAL));
                stacks.add(new ItemStack((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL));
            }
        }
        return Stream.of(new StackList(stacks));
    }

    public boolean hasToBeAttuned() {
        return this.hasToBeAttuned;
    }

    public boolean hasToBeCelestial() {
        return this.hasToBeCelestial;
    }

    public boolean canBeAttuned() {
        return this.canBeAttuned;
    }

    public boolean canBeCelestialCrystal() {
        return this.canBeCelestialCrystal;
    }

    public JsonElement func_200304_c() {
        JsonObject object = new JsonObject();
        object.addProperty("type", CraftingHelper.getID(IngredientSerializersAS.CRYSTAL_SERIALIZER).toString());
        object.addProperty("hasToBeAttuned", Boolean.valueOf(this.hasToBeAttuned()));
        object.addProperty("hasToBeCelestial", Boolean.valueOf(this.hasToBeCelestial()));
        object.addProperty("canBeAttuned", Boolean.valueOf(this.canBeAttuned()));
        object.addProperty("canBeCelestialCrystal", Boolean.valueOf(this.canBeCelestialCrystal()));
        return object;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializersAS.CRYSTAL_SERIALIZER;
    }
}

