/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.sync.client;

import hellfirepvp.astralsorcery.common.data.sync.base.ClientData;
import hellfirepvp.astralsorcery.common.data.sync.base.ClientDataReader;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class ClientTimeFreezeEffects
extends ClientData<ClientTimeFreezeEffects> {
    private final Map<RegistryKey<World>, List<TimeStopEffectHelper>> clientActiveFreezeZones = new HashMap<RegistryKey<World>, List<TimeStopEffectHelper>>();

    @Nonnull
    public List<TimeStopEffectHelper> getTimeStopEffects(World world) {
        return this.getTimeStopEffects((RegistryKey<World>)world.func_234923_W_());
    }

    @Nonnull
    public List<TimeStopEffectHelper> getTimeStopEffects(RegistryKey<World> dim) {
        return this.clientActiveFreezeZones.getOrDefault(dim, Collections.emptyList());
    }

    private void applyChange(DataTimeFreezeEffects.ServerSyncAction action) {
        RegistryKey<World> worldKey = action.getDimKey();
        switch (action.getType()) {
            case ADD: {
                List zones = this.clientActiveFreezeZones.computeIfAbsent(worldKey, id -> new LinkedList());
                zones.add(action.getInvolvedEffect());
                break;
            }
            case REMOVE: {
                if (!this.clientActiveFreezeZones.containsKey(worldKey)) break;
                this.clientActiveFreezeZones.get(worldKey).remove(action.getInvolvedEffect());
                break;
            }
            case CLEAR: {
                this.clientActiveFreezeZones.remove(worldKey);
                break;
            }
        }
    }

    @Override
    public void clear(RegistryKey<World> dim) {
        this.clientActiveFreezeZones.remove(dim);
    }

    @Override
    public void clearClient() {
        this.clientActiveFreezeZones.clear();
    }

    public static class Reader
    extends ClientDataReader<ClientTimeFreezeEffects> {
        @Override
        public void readFromIncomingFullSync(ClientTimeFreezeEffects data, CompoundNBT compound) {
            data.clientActiveFreezeZones.clear();
            CompoundNBT dimTag = compound.func_74775_l("dimTypes");
            for (String dimKey : dimTag.func_150296_c()) {
                RegistryKey dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimKey));
                LinkedList<TimeStopEffectHelper> effects = new LinkedList<TimeStopEffectHelper>();
                ListNBT listEffects = dimTag.func_150295_c(dimKey, 10);
                for (INBT iNBT : listEffects) {
                    effects.add(TimeStopEffectHelper.deserializeNBT((CompoundNBT)iNBT));
                }
                data.clientActiveFreezeZones.put(dim, effects);
            }
        }

        @Override
        public void readFromIncomingDiff(ClientTimeFreezeEffects data, CompoundNBT compound) {
            ListNBT changes = compound.func_150295_c("changes", 10);
            for (INBT iNBT : changes) {
                DataTimeFreezeEffects.ServerSyncAction action = DataTimeFreezeEffects.ServerSyncAction.deserializeNBT((CompoundNBT)iNBT);
                data.applyChange(action);
            }
        }
    }
}

