/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.effect;

import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.query.SpriteQuery;
import hellfirepvp.astralsorcery.common.effect.EffectCustomTexture;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EffectsAS;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class EffectDropModifier
extends EffectCustomTexture {
    public EffectDropModifier() {
        super(EffectType.BENEFICIAL, ColorsAS.EFFECT_DROP_MODIFIER);
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>(0);
    }

    @Override
    public void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(EventPriority.HIGH, this::onDrops);
    }

    private void onDrops(LivingDropsEvent event) {
        LivingEntity le = event.getEntityLiving();
        if (le.func_130014_f_().func_201670_d() || !(le instanceof MobEntity) || !(le.func_130014_f_() instanceof ServerWorld) || !le.func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            return;
        }
        if (le.func_70644_a((Effect)EffectsAS.EFFECT_DROP_MODIFIER)) {
            DamageSource src = event.getSource();
            int amplifier = le.func_184596_c((Effect)EffectsAS.EFFECT_DROP_MODIFIER).func_76458_c();
            if (amplifier == 0) {
                event.getDrops().clear();
            } else {
                for (int i = 0; i < amplifier; ++i) {
                    List<ItemStack> loot = EntityUtils.generateLoot(le, rand, src, event.isRecentlyHit() ? le.func_94060_bK() : null);
                    for (ItemStack stack : loot) {
                        if (stack.func_190926_b()) continue;
                        event.getDrops().add(le.func_199701_a_(stack));
                    }
                }
            }
        }
    }

    @Override
    public SpriteQuery getSpriteQuery() {
        return new SpriteQuery(AssetLoader.TextureLocation.GUI, 1, 1, "effect", "drop_modifier");
    }
}

