/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entity;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingSprite;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.data.config.entry.EntityConfig;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.entity.EntityUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityFlare
extends FlyingEntity {
    private static final int RANDOM_WANDER_RANGE = 31;
    private int entityAge = 0;
    private Vector3 currentMoveTarget = null;
    private boolean ambient = false;
    private int followingEntityId = -1;
    private Object texClientSprite = null;

    public EntityFlare(World worldIn) {
        super(EntityTypesAS.FLARE, worldIn);
    }

    public static EntityType.IFactory<EntityFlare> factory() {
        return (type, world) -> new EntityFlare(world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0);
    }

    public static void spawnAmbientFlare(World world, BlockPos at) {
        if (world.func_201670_d() || (Integer)EntityConfig.CONFIG.flareAmbientSpawnChance.get() <= 0) {
            return;
        }
        float nightPercent = DayTimeHelper.getCurrentDaytimeDistribution(world);
        if (world.field_73012_v.nextInt((Integer)EntityConfig.CONFIG.flareAmbientSpawnChance.get()) == 0 && world.field_73012_v.nextFloat() < nightPercent) {
            MiscUtils.executeWithChunk((IWorldReader)world, at, () -> {
                if (world.func_175623_d(at)) {
                    EntityFlare flare = (EntityFlare)EntityTypesAS.FLARE.func_200721_a(world);
                    flare.func_70107_b((double)at.func_177958_n() + 0.5, (double)at.func_177956_o() + 0.5, (double)at.func_177952_p() + 0.5);
                    flare.setAmbient(true);
                    world.func_217376_c((Entity)flare);
                }
            });
        }
    }

    public EntityFlare setAmbient(boolean ambient) {
        this.ambient = ambient;
        return this;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public EntityFlare setFollowingTarget(LivingEntity entity) {
        this.followingEntityId = entity.func_145782_y();
        return this;
    }

    @Nullable
    public LivingEntity getFollowingTarget() {
        if (this.followingEntityId == -1) {
            return null;
        }
        Entity e = this.field_70170_p.func_73045_a(this.followingEntityId);
        if (e == null || !e.func_70089_S() || !(e instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)e;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.entityAge;
        if (this.func_130014_f_().func_201670_d()) {
            this.tickClient();
        } else {
            if (this.isAmbient() && this.entityAge > 600 && this.field_70146_Z.nextInt(600) == 0) {
                DamageUtil.attackEntityFrom((Entity)this, CommonProxy.DAMAGE_SOURCE_STELLAR, 1.0f);
            }
            if (this.func_70089_S()) {
                BatEntity closest;
                if (((Boolean)EntityConfig.CONFIG.flareAttackBats.get()).booleanValue() && this.field_70146_Z.nextInt(30) == 0 && (closest = EntityUtils.getClosestEntity((IWorld)this.func_130014_f_(), BatEntity.class, this.func_174813_aQ().func_186662_g(10.0), Vector3.atEntityCenter((Entity)this))) != null) {
                    this.doLightningAttack((LivingEntity)closest, 100.0f);
                }
                if (((Boolean)EntityConfig.CONFIG.flareAttackPhantoms.get()).booleanValue() && this.field_70146_Z.nextInt(30) == 0 && (closest = EntityUtils.getClosestEntity((IWorld)this.func_130014_f_(), PhantomEntity.class, this.func_174813_aQ().func_186662_g(10.0), Vector3.atEntityCenter((Entity)this))) != null) {
                    this.doLightningAttack((LivingEntity)closest, 100.0f);
                }
                if (this.isAmbient()) {
                    BlockPos newTarget;
                    boolean atTarget;
                    boolean bl = atTarget = this.currentMoveTarget == null || this.currentMoveTarget.distance((Entity)this) < 5.0;
                    if (atTarget) {
                        this.currentMoveTarget = null;
                    }
                    if (this.currentMoveTarget == null && this.field_70146_Z.nextInt(150) == 0 && (newTarget = this.func_233580_cy_().func_177982_a(this.field_70146_Z.nextInt(31) * (this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70146_Z.nextInt(31) * (this.field_70146_Z.nextBoolean() ? 1 : -1), this.field_70146_Z.nextInt(31) * (this.field_70146_Z.nextBoolean() ? 1 : -1))).func_177956_o() > 1 && newTarget.func_177956_o() < 254) {
                        Vector3 vector3 = new Vector3((Vector3i)newTarget);
                        if (vector3.distance((Entity)this) >= 5.0) {
                            MiscUtils.executeWithChunk((IWorldReader)this.func_130014_f_(), newTarget, () -> {
                                this.currentMoveTarget = new Vector3((Vector3i)newTarget);
                            });
                        }
                    }
                } else if (this.func_70638_az() != null) {
                    if (!this.func_70638_az().func_70089_S() || this.getFollowingTarget() != null && this.getFollowingTarget().func_70032_d((Entity)this) > 30.0f) {
                        this.func_70624_b(null);
                    } else {
                        Vector3 newTarget = Vector3.atEntityCenter((Entity)this.func_70638_az()).addY(1.5);
                        this.currentMoveTarget = newTarget.getY() > 1.0 && newTarget.getY() < 254.0 && newTarget.distance((Entity)this) >= 3.0 ? newTarget : null;
                    }
                } else if (this.followingEntityId != -1) {
                    LivingEntity following = this.getFollowingTarget();
                    if (following == null) {
                        DamageUtil.attackEntityFrom((Entity)this, CommonProxy.DAMAGE_SOURCE_STELLAR, 1.0f);
                    } else {
                        MantleEffectBootes effect = (MantleEffectBootes)((Object)ItemMantle.getEffect(following, ConstellationsAS.bootes));
                        if (effect == null) {
                            DamageUtil.attackEntityFrom((Entity)this, CommonProxy.DAMAGE_SOURCE_STELLAR, 1.0f);
                            return;
                        }
                        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
                            this.func_70624_b(null);
                        }
                        if (this.func_70638_az() == null) {
                            Vector3 newTarget = Vector3.atEntityCenter((Entity)following).addY(2.5);
                            this.currentMoveTarget = newTarget.distance((Entity)this) >= 2.0 ? newTarget : null;
                        }
                    }
                } else {
                    DamageUtil.attackEntityFrom((Entity)this, CommonProxy.DAMAGE_SOURCE_STELLAR, 1.0f);
                    return;
                }
                LivingEntity target = this.func_70638_az();
                if (target != null && target.func_70089_S() && target.func_70032_d((Entity)this) < 10.0f && this.field_70146_Z.nextInt(40) == 0) {
                    DamageUtil.shotgunAttack(target, e -> this.doLightningAttack((LivingEntity)e, 2.0f + this.field_70146_Z.nextFloat() * 2.0f));
                }
                this.doMovement();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.texClientSprite == null) {
            this.texClientSprite = ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingSprite)EffectHelper.of(EffectTemplatesAS.FACING_SPRITE).spawn(Vector3.atEntityCorner((Entity)this).addY(this.func_213302_cg() / 2.0f))).setSprite(SpritesAS.SPR_ENTITY_FLARE).setScaleMultiplier(0.45f)).position((fx, position, motionToBeMoved) -> Vector3.atEntityCorner((Entity)this).addY(this.func_213302_cg() / 2.0f))).scale((fx, scaleIn, pTicks) -> this.func_70089_S() ? scaleIn : 0.0f)).refresh(fx -> this.func_70089_S());
        } else if (this.func_70089_S()) {
            EffectHelper.refresh((FXFacingSprite)this.texClientSprite, EffectTemplatesAS.FACING_SPRITE);
        }
        if (this.field_70146_Z.nextBoolean()) {
            FXFacingParticle p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this).add((double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)(this.func_213302_cg() / 2.0f) + (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.2 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1)))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + this.field_70146_Z.nextFloat() * 0.1f);
            if (this.field_70146_Z.nextBoolean()) {
                p.color(VFXColorFunction.WHITE);
            }
        }
    }

    private void doLightningAttack(LivingEntity target, float damage) {
        DamageUtil.attackEntityFrom((Entity)target, CommonProxy.DAMAGE_SOURCE_STELLAR, damage, (Entity)this);
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIGHTNING).addData(buf -> {
            ByteBufUtils.writeVector(buf, Vector3.atEntityCorner((Entity)this).addY(this.func_213302_cg() / 2.0f));
            ByteBufUtils.writeVector(buf, Vector3.atEntityCorner((Entity)target).addY(target.func_213302_cg() / 2.0f));
            buf.writeInt(ColorsAS.EFFECT_LIGHTNING.getRGB());
        });
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(this.func_130014_f_(), (Vector3i)this.func_233580_cy_(), 32.0));
    }

    private void doMovement() {
        if (this.currentMoveTarget != null) {
            Vector3d motion = this.func_213322_ci();
            double motionX = (Math.signum(this.currentMoveTarget.getX() - this.func_226277_ct_()) * 0.5 - motion.func_82615_a()) * (this.isAmbient() ? 0.01 : 0.025);
            double motionY = (Math.signum(this.currentMoveTarget.getY() - this.func_226278_cu_()) * 0.7 - motion.func_82617_b()) * (this.isAmbient() ? 0.01 : 0.025);
            double motionZ = (Math.signum(this.currentMoveTarget.getZ() - this.func_226281_cx_()) * 0.5 - motion.func_82616_c()) * (this.isAmbient() ? 0.01 : 0.025);
            this.func_213317_d(motion.func_72441_c(motionX, motionY, motionZ));
            this.field_191988_bg = 0.2f;
        }
    }

    public void func_70108_f(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.func_70606_j(0.0f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return false;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_70609_aI() {
        this.func_70106_y();
        if (this.func_130014_f_().func_201670_d()) {
            this.tickClientDeathEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClientDeathEffects() {
        if (this.texClientSprite != null) {
            ((FXFacingSprite)this.texClientSprite).requestRemoval();
        }
        List<Vector3> posList = MiscUtils.getCirclePositions(Vector3.atEntityCorner((Entity)this).addY(this.func_213302_cg() / 2.0f), Vector3.positiveYRandom(), 0.3, 10);
        posList.addAll(MiscUtils.getCirclePositions(Vector3.atEntityCorner((Entity)this).addY(this.func_213302_cg() / 2.0f), Vector3.positiveYRandom(), 0.8, 20));
        posList.forEach(pos -> {
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos.add(Vector3.random().multiply(0.45f)))).setScaleMultiplier(0.1f + this.field_70146_Z.nextFloat() * 0.25f)).alpha(VFXAlphaFunction.FADE_OUT)).setMaxAge(30 + this.field_70146_Z.nextInt(40));
            if (this.field_70146_Z.nextBoolean()) {
                p.color(VFXColorFunction.WHITE);
            }
        });
        for (int i = 0; i < 10; ++i) {
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(Vector3.atEntityCorner((Entity)this).add((double)this.field_70146_Z.nextFloat() * 0.15 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)(this.func_213302_cg() / 2.0f) + (double)this.field_70146_Z.nextFloat() * 0.15 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1), (double)this.field_70146_Z.nextFloat() * 0.15 * (double)(this.field_70146_Z.nextBoolean() ? 1 : -1)))).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(Vector3.random().multiply(0.05f))).setScaleMultiplier(0.25f + this.field_70146_Z.nextFloat() * 0.1f)).setMaxAge(40 + this.field_70146_Z.nextInt(40));
            if (!this.field_70146_Z.nextBoolean()) continue;
            p.color(VFXColorFunction.WHITE);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AS_entityAge", this.entityAge);
        compound.func_74757_a("AS_ambient", this.ambient);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.entityAge = compound.func_74762_e("AS_entityAge");
        this.ambient = compound.func_74767_n("AS_ambient");
    }
}

