/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHelperDamageCancelling {
    private static final Map<UUID, Set<DamageSource>> invulnerableTypes = new HashMap<UUID, Set<DamageSource>>();

    private EventHelperDamageCancelling() {
    }

    public static void markInvulnerableToNextDamage(PlayerEntity player, DamageSource source) {
        if (player.func_130014_f_().func_201670_d()) {
            return;
        }
        invulnerableTypes.computeIfAbsent(player.func_110124_au(), uuid -> new HashSet()).add(source);
    }

    public static void attachListeners(IEventBus bus) {
        bus.addListener(EventHelperDamageCancelling::onLivingDamage);
        bus.addListener(EventHelperDamageCancelling::onPlayerTick);
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && !player.func_130014_f_().func_201670_d() && player.func_233570_aj_()) {
            Set sources = invulnerableTypes.getOrDefault(event.player.func_110124_au(), Collections.emptySet());
            sources.remove(DamageSource.field_76379_h);
        }
    }

    private static void onLivingDamage(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        Set sources = invulnerableTypes.getOrDefault(player.func_110124_au(), Collections.emptySet());
        if (sources.remove(event.getSource())) {
            if (sources.isEmpty()) {
                invulnerableTypes.remove(player.func_110124_au());
            }
            event.setCanceled(true);
        }
    }
}

