/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.integration.IntegrationJEI;
import hellfirepvp.astralsorcery.common.integration.jei.JEICategory;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;

public class CategoryWell
extends JEICategory<WellLiquefaction> {
    private final IDrawable background;
    private final IDrawable icon;

    public CategoryWell(IGuiHelper guiHelper) {
        super(IntegrationJEI.CATEGORY_WELL);
        this.background = guiHelper.createDrawable(AstralSorcery.key("textures/gui/jei/lightwell.png"), 0, 0, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlocksAS.WELL));
    }

    public Class<? extends WellLiquefaction> getRecipeClass() {
        return WellLiquefaction.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(WellLiquefaction recipe, MatrixStack renderStack, double mouseX, double mouseY) {
        this.icon.draw(renderStack, 46, 20);
    }

    @Override
    public List<WellLiquefaction> getRecipes() {
        return RecipeTypesAS.TYPE_WELL.getAllRecipes();
    }

    public void setIngredients(WellLiquefaction wellLiquefaction, IIngredients ingredients) {
        ImmutableList.Builder fluidOutputs = ImmutableList.builder();
        ImmutableList.Builder itemInputs = ImmutableList.builder();
        itemInputs.add(CategoryWell.ingredientStacks(wellLiquefaction.getInput()));
        fluidOutputs.add(Collections.singletonList(new FluidStack(wellLiquefaction.getFluidOutput(), 1000)));
        ingredients.setInputLists(VanillaTypes.ITEM, (List)itemInputs.build());
        ingredients.setOutputLists(VanillaTypes.FLUID, (List)fluidOutputs.build());
    }

    public void setRecipe(IRecipeLayout recipeLayout, WellLiquefaction wellLiquefaction, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        itemStacks.init(0, true, 2, 18);
        CategoryWell.initFluidOutput(fluidStacks, 1, 94, 18);
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
    }
}

