/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.container.ContainerAltarBase;
import hellfirepvp.astralsorcery.common.container.ContainerTileEntity;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryAltar;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.util.MapStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.config.ServerInfo;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TieredAltarRecipeTransferHandler<C extends ContainerAltarBase>
implements IRecipeTransferHandler<C> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Class<C> containerClass;
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final int maxListSize;

    public TieredAltarRecipeTransferHandler(Class<C> containerClass, IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, int maxListSize) {
        this.containerClass = containerClass;
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.maxListSize = maxListSize;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        if (!ServerInfo.isJeiOnServer()) {
            String tooltipMessage = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        if (!this.containerClass.isAssignableFrom(container.getClass())) {
            return this.handlerHelper.createInternalError();
        }
        IRecipeCategory category = recipeLayout.getRecipeCategory();
        if (!(category instanceof CategoryAltar)) {
            return this.handlerHelper.createInternalError();
        }
        AltarType recipeTier = ((CategoryAltar)category).getAltarType();
        AltarType altarTier = ((TileAltar)((ContainerTileEntity)((Object)container)).getTileEntity()).getAltarType();
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Object slot : ((ContainerAltarBase)((Object)container)).field_75151_b.subList(0, 36)) {
            inventorySlots.put(((Slot)slot).field_75222_d, (Slot)slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : ((ContainerAltarBase)((Object)container)).field_75151_b.subList(36, 36 + this.maxListSize)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        int inputCount = 0;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        HashMap itemStacks = new HashMap();
        for (Map.Entry entry : itemStackGroup.getGuiIngredients().entrySet()) {
            if ((Integer)entry.getKey() >= 25) continue;
            itemStacks.put(entry.getKey(), entry.getValue());
        }
        for (IGuiIngredient ingredient : itemStacks.values()) {
            if (!ingredient.isInput() || ingredient.getAllIngredients().isEmpty()) continue;
            ++inputCount;
        }
        if (inputCount > craftingSlots.size()) {
            LOGGER.error("Recipe Transfer does not work for container {}", container.getClass());
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (!slot.func_82869_a(player)) {
                LOGGER.error("Recipe Transfer does not work for container {}. Player can't move item out of Crafting Slot number {}", container.getClass(), (Object)slot.field_75222_d);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        RecipeTransferUtil.MatchingItemsResult matchingItemsResult = RecipeTransferUtil.getMatchingItems((IStackHelper)this.stackHelper, availableItemStacks, itemStacks);
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
            return this.handlerHelper.createUserErrorForSlots(message, (Collection)matchingItemsResult.missingItems);
        }
        ArrayList craftingSlotIndexes = new ArrayList(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList inventorySlotIndexes = new ArrayList(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        Map matchIndices = MapStream.of(matchingItemsResult.matchingItems).mapKey(arg_0 -> container.translateIndex(arg_0)).toMap();
        for (Map.Entry entry : matchIndices.entrySet()) {
            int craftNumber = entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < ((ContainerAltarBase)((Object)container)).field_75151_b.size()) continue;
            LOGGER.error("Recipes Transfer references slot {} outside of the inventory's size {}", (Object)slotNumber, (Object)((ContainerAltarBase)((Object)container)).field_75151_b.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchIndices, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, true);
            Network.sendPacketToServer((PacketJei)packet);
        }
        return null;
    }
}

