/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.loot.global;

import com.google.gson.JsonObject;
import hellfirepvp.astralsorcery.common.data.config.registry.OreItemRarityRegistry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyVoidTrash;
import hellfirepvp.astralsorcery.common.util.loot.LootUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.LogicalSide;

public class LootModifierPerkVoidTrash
extends LootModifier {
    private LootModifierPerkVoidTrash(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!LootUtil.doesContextFulfillSet(context, LootParameterSets.field_216267_h)) {
            return generatedLoot;
        }
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(e instanceof PlayerEntity)) {
            return generatedLoot;
        }
        PlayerEntity player = (PlayerEntity)e;
        PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (!prog.isValid() || !prog.getPerkData().hasPerkEffect(perk -> perk instanceof KeyVoidTrash)) {
            return generatedLoot;
        }
        if (!PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, perk -> perk instanceof KeyVoidTrash).isPresent()) {
            return generatedLoot;
        }
        double chance = KeyVoidTrash.CONFIG.getOreChance() * (double)PerkAttributeHelper.getOrCreateMap(player, LogicalSide.SERVER).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        return generatedLoot.stream().filter(stack -> !stack.func_190926_b()).map(result -> {
            if (KeyVoidTrash.CONFIG.isTrash((ItemStack)result)) {
                Item drop;
                result = ItemStack.field_190927_a;
                if ((double)context.func_216032_b().nextFloat() < chance && (drop = OreItemRarityRegistry.VOID_TRASH_REWARD.getRandomItem(context.func_216032_b())) != null) {
                    result = new ItemStack((IItemProvider)drop);
                }
            }
            return result;
        }).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<LootModifierPerkVoidTrash> {
        public LootModifierPerkVoidTrash read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new LootModifierPerkVoidTrash(lootConditions);
        }

        public JsonObject write(LootModifierPerkVoidTrash instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

