/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeModifierPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreeConstellation;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class ConstellationPerk
extends AttributeModifierPerk {
    private IConstellation constellation;

    public ConstellationPerk(ResourceLocation name, IConstellation cst, float x, float y) {
        super(name, x, y);
        this.setConstellation(cst);
    }

    public static ConstellationPerk convertToThis(ResourceLocation perkKey, float x, float y) {
        return new ConstellationPerk(perkKey, null, x, y);
    }

    protected PerkTreePoint<? extends ConstellationPerk> initPerkTreePoint() {
        Validate.notNull((Object)this.constellation);
        return new PerkTreeConstellation<ConstellationPerk>(this, this.getOffset(), this.constellation, 40);
    }

    public void setConstellation(IConstellation constellation) {
        Validate.isTrue((this.constellation == null ? 1 : 0) != 0);
        Validate.notNull((Object)constellation);
        this.constellation = constellation;
    }

    public IConstellation getConstellation() {
        Validate.notNull((Object)this.constellation);
        return this.constellation;
    }

    @Override
    public void deserializeData(JsonObject perkData) {
        super.deserializeData(perkData);
        this.constellation = null;
        if (perkData.has("constellation")) {
            String cstKey = JSONUtils.func_151200_h((JsonObject)perkData, (String)"constellation");
            IConstellation cst = ConstellationRegistry.getConstellation(new ResourceLocation(cstKey));
            if (cst == null) {
                throw new JsonParseException("Unknown constellation: " + cstKey);
            }
            this.setConstellation(cst);
        }
    }

    @Override
    public void serializeData(JsonObject perkData) {
        super.serializeData(perkData);
        if (this.constellation != null) {
            perkData.addProperty("constellation", this.constellation.getRegistryName().toString());
        }
    }
}

