/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.tree;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.screen.journal.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.screen.journal.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.screen.journal.perk.group.PerkPointHaloRenderGroup;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.draw.BufferContext;
import hellfirepvp.astralsorcery.common.perk.AllocationStatus;
import hellfirepvp.astralsorcery.common.perk.node.MajorPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PerkTreeMajor<T extends MajorPerk>
extends PerkTreePoint<T> {
    public PerkTreeMajor(T perk, Point2D.Float offset) {
        super(perk, offset);
        this.setRenderSize((int)((double)this.getRenderSize() * 1.4));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        super.addGroups(groups);
        groups.add(PerkPointHaloRenderGroup.INSTANCE);
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle2D.Float renderPerkAtBatch(BatchPerkContext drawCtx, MatrixStack renderStack, AllocationStatus status, long spriteOffsetTick, float pTicks, float x, float y, float zLevel, float scale) {
        SpriteSheetResource tex = status.getPerkTreeHaloSprite();
        BatchPerkContext.TextureObjectGroup grp = PerkPointHaloRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Float();
        }
        BufferContext buf = drawCtx.getContext(grp);
        float haloSize = (float)this.getRenderSize() * 0.8f * scale;
        if (status.isAllocated()) {
            haloSize = (float)((double)haloSize * 1.5);
        }
        Tuple<Float, Float> frameUV = tex.getUVOffset(spriteOffsetTick);
        RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, x - haloSize, y - haloSize, zLevel, haloSize * 2.0f, haloSize * 2.0f).color(1.0f, 1.0f, 1.0f, 0.85f).tex(((Float)frameUV.func_76341_a()).floatValue(), ((Float)frameUV.func_76340_b()).floatValue(), tex.getULength(), tex.getVLength()).draw();
        super.renderPerkAtBatch(drawCtx, renderStack, status, spriteOffsetTick, pTicks, x, y, zLevel, scale);
        float actualSize = (float)this.getRenderSize() * scale;
        return new Rectangle2D.Float(-actualSize, -actualSize, actualSize * 2.0f, actualSize * 2.0f);
    }
}

