/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.event.CooldownSetEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeCooldown
extends PerkAttributeType {
    public AttributeTypeCooldown() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_COOLDOWN_REDUCTION, true);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(this::onCooldown);
    }

    private void onCooldown(CooldownSetEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (world.func_201670_d()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (!prog.isValid()) {
            return;
        }
        if (player instanceof ServerPlayerEntity && MiscUtils.isPlayerFakeMP((ServerPlayerEntity)player)) {
            return;
        }
        float multiplier = PerkAttributeHelper.getOrCreateMap(player, LogicalSide.SERVER).modifyValue(player, prog, this, 1.0f);
        multiplier -= 1.0f;
        multiplier = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, multiplier);
        multiplier = 1.0f - MathHelper.func_76131_a((float)multiplier, (float)0.0f, (float)1.0f);
        event.setCooldown(Math.round((float)event.getResultCooldown() * multiplier));
    }
}

