/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeModifierDodge;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeDodge
extends PerkAttributeType {
    public static final Config CONFIG = new Config("type." + PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_DODGE.func_110623_a());

    public AttributeTypeDodge() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_DODGE);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(EventPriority.HIGH, this::onDamageTaken);
    }

    @Override
    @Nonnull
    public PerkAttributeModifier createModifier(float modifier, ModifierType mode) {
        return new AttributeModifierDodge(this, mode, modifier);
    }

    private void onDamageTaken(LivingDamageEvent event) {
        LogicalSide side;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float chance = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 0.0f);
        chance /= 100.0f;
        if ((chance = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, chance)) >= rand.nextFloat() && AlignmentChargeHandler.INSTANCE.drainCharge(player, side, ((Integer)CONFIG.chargeCost.get()).intValue(), false)) {
            event.setCanceled(true);
        }
    }

    private static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per dodged damage.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 80, 1, 500);
        }
    }
}

