/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeLifeRecovery
extends PerkAttributeType {
    public AttributeTypeLifeRecovery() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_LIFE_RECOVERY, true);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(EventPriority.LOW, this::onHeal);
    }

    private void onHeal(LivingHealEvent event) {
        LogicalSide side;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float heal = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, event.getAmount());
        float val = heal = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, heal);
        if (val <= 0.0f) {
            event.setCanceled(true);
        } else {
            event.setAmount(val);
        }
    }
}

