/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.altar;

import hellfirepvp.astralsorcery.client.util.sound.FadeLoopSound;
import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipeContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.ActiveSimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.item.base.IConstellationFocus;
import hellfirepvp.astralsorcery.common.item.wand.WandInteractable;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.TileSpectralRelay;
import hellfirepvp.astralsorcery.common.tile.altar.AltarCollectionCategory;
import hellfirepvp.astralsorcery.common.tile.altar.DeferredStarlightStorage;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.network.TileReceiverBase;
import hellfirepvp.astralsorcery.common.tile.network.StarlightReceiverAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.sound.CategorizedSoundEvent;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventoryFiltered;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;

public class TileAltar
extends TileReceiverBase<StarlightReceiverAltar>
implements WandInteractable {
    private float posDistribution = -1.0f;
    private AltarType altarType = AltarType.DISCOVERY;
    private TileInventoryFiltered inventory;
    private final Map<AltarCollectionCategory, Float> tickStarlightCollectionMap = new HashMap<AltarCollectionCategory, Float>();
    private ActiveSimpleAltarRecipe activeRecipe = null;
    private ItemStack focusItem = ItemStack.field_190927_a;
    private Set<ResourceLocation> knownRecipes = new HashSet<ResourceLocation>();
    private final DeferredStarlightStorage starlightStorage = new DeferredStarlightStorage(2);
    private int starlightNextTick = 0;
    private Object clientCraftSound = null;
    private Object clientWaitSound = null;

    public TileAltar() {
        super(TileEntityTypesAS.ALTAR);
        this.inventory = new TileInventoryFiltered((TileEntitySynchronized)this, () -> 25, new Direction[0]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            this.doesSeeSky();
            this.hasMultiblock();
            this.gatherStarlight();
            this.doCraftingCycle();
        } else if (this.getActiveRecipe() != null) {
            this.doCraftEffects();
            this.doCraftSound();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doCraftEffects() {
        this.activeRecipe.getRecipeToCraft().getCraftingEffects().forEach(effect -> effect.onTick(this, this.activeRecipe.getState()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doCraftSound() {
        if (SoundHelper.getSoundVolume(SoundCategory.BLOCKS) > 0.0f) {
            ActiveSimpleAltarRecipe activeRecipe = this.getActiveRecipe();
            AltarType type = this.getAltarType();
            if (this.clientCraftSound == null || ((PositionedLoopSound)((Object)this.clientCraftSound)).hasStoppedPlaying()) {
                CategorizedSoundEvent sound = SoundsAS.ALTAR_CRAFT_LOOP_T1;
                switch (type) {
                    case ATTUNEMENT: {
                        sound = SoundsAS.ALTAR_CRAFT_LOOP_T2;
                        break;
                    }
                    case CONSTELLATION: {
                        sound = SoundsAS.ALTAR_CRAFT_LOOP_T3;
                        break;
                    }
                    case RADIANCE: {
                        sound = SoundsAS.ALTAR_CRAFT_LOOP_T4;
                    }
                }
                this.clientCraftSound = ((FadeLoopSound)((Object)SoundHelper.playSoundLoopFadeInClient(sound, new Vector3(this).add(0.5, 0.5, 0.5), 0.6f, 1.0f, false, s -> this.func_145837_r() || SoundHelper.getSoundVolume(SoundCategory.BLOCKS) <= 0.0f || this.getActiveRecipe() == null).setFadeInTicks(40.0f))).setFadeOutTicks(20.0f);
            }
            if (activeRecipe.getState() == ActiveSimpleAltarRecipe.CraftingState.WAITING && type.isThisGEThan(AltarType.RADIANCE)) {
                if (this.clientWaitSound == null || ((PositionedLoopSound)((Object)this.clientWaitSound)).hasStoppedPlaying()) {
                    this.clientWaitSound = ((FadeLoopSound)((Object)SoundHelper.playSoundLoopFadeInClient(SoundsAS.ALTAR_CRAFT_LOOP_T4_WAITING, new Vector3(this).add(0.5, 0.5, 0.5), 0.7f, 1.0f, false, s -> this.func_145837_r() || SoundHelper.getSoundVolume(SoundCategory.BLOCKS) <= 0.0f || this.getActiveRecipe() == null || this.getActiveRecipe().getState() != ActiveSimpleAltarRecipe.CraftingState.WAITING).setFadeInTicks(30.0f))).setFadeOutTicks(10.0f);
                }
                ((PositionedLoopSound)((Object)this.clientCraftSound)).setVolumeMultiplier(0.75f);
            } else {
                ((PositionedLoopSound)((Object)this.clientCraftSound)).setVolumeMultiplier(1.0f);
            }
        } else {
            this.clientWaitSound = null;
            this.clientCraftSound = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void finishCraftingEffects(PktPlayEffect pkt) {
        ResourceLocation recipeName = ByteBufUtils.readResourceLocation(pkt.getExtraData());
        BlockPos at = ByteBufUtils.readPos(pkt.getExtraData());
        boolean isChaining = pkt.getExtraData().readBoolean();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileAltar thisAltar = MiscUtils.getTileAt((IBlockReader)world, at, TileAltar.class, false);
        if (thisAltar != null) {
            IRecipe recipe = (IRecipe)world.func_199532_z().func_215366_a(RecipeTypesAS.TYPE_ALTAR.getType()).get(recipeName);
            if (recipe instanceof SimpleAltarRecipe) {
                ((SimpleAltarRecipe)recipe).getCraftingEffects().forEach(effect -> effect.onCraftingFinish(thisAltar, isChaining));
            }
            if (!isChaining) {
                SoundHelper.playSoundClientWorld(SoundsAS.ALTAR_CRAFT_FINISH, at, 0.6f, 1.0f);
            }
        }
    }

    private void doCraftingCycle() {
        if (this.activeRecipe == null) {
            return;
        }
        if (!this.hasMultiblock() || !this.activeRecipe.matches(this, false, false)) {
            this.abortCrafting();
            return;
        }
        if (this.activeRecipe.isFinished()) {
            this.finishRecipe();
            return;
        }
        this.activeRecipe.setState(this.activeRecipe.tick(this));
    }

    private void finishRecipe() {
        ActiveSimpleAltarRecipe finishedRecipe = this.activeRecipe;
        ForgeHooks.setCraftingPlayer((PlayerEntity)finishedRecipe.tryGetCraftingPlayerServer());
        finishedRecipe.createItemOutputs(this, this::dropItemOnTop);
        finishedRecipe.consumeInputs(this);
        ForgeHooks.setCraftingPlayer(null);
        ResourceLocation recipeName = finishedRecipe.getRecipeToCraft().func_199560_c();
        boolean isChaining = finishedRecipe.matches(this, false, true);
        if (!isChaining) {
            this.abortCrafting();
            EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-3 + rand.nextInt(7), 1 + rand.nextInt(3), -3 + rand.nextInt(7)));
            EntityFlare.spawnAmbientFlare(this.func_145831_w(), this.func_174877_v().func_177982_a(-3 + rand.nextInt(7), 1 + rand.nextInt(3), -3 + rand.nextInt(7)));
        }
        PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.ALTAR_RECIPE_FINISH).addData(buf -> {
            ByteBufUtils.writeResourceLocation(buf, recipeName);
            ByteBufUtils.writePos(buf, this.func_174877_v());
            buf.writeBoolean(isChaining);
        });
        PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos(this.func_145831_w(), (Vector3i)this.func_174877_v(), 32.0));
        this.knownRecipes.add(recipeName);
        this.markForUpdate();
    }

    private void abortCrafting() {
        this.activeRecipe = null;
        this.markForUpdate();
    }

    protected SimpleAltarRecipe findRecipe(PlayerEntity crafter) {
        return RecipeTypesAS.TYPE_ALTAR.findRecipe(new SimpleAltarRecipeContext(crafter, LogicalSide.SERVER, this).setIgnoreStarlightRequirement(false));
    }

    protected boolean startCrafting(SimpleAltarRecipe recipe, PlayerEntity crafter) {
        if (this.getActiveRecipe() != null) {
            return false;
        }
        int divisor = Math.max(0, this.getAltarType().ordinal() - recipe.getAltarType().ordinal());
        divisor = (int)Math.round(Math.pow(2.0, divisor));
        this.activeRecipe = new ActiveSimpleAltarRecipe(recipe, divisor, crafter.func_110124_au());
        this.markForUpdate();
        SoundHelper.playSoundAround((SoundEvent)SoundsAS.ALTAR_CRAFT_START, SoundCategory.BLOCKS, this.field_145850_b, new Vector3(this).add(0.5, 0.5, 0.5), 0.6f, 1.0f);
        return true;
    }

    @Override
    public boolean onInteract(World world, BlockPos pos, PlayerEntity player, Direction side, boolean sneak) {
        if (!world.func_201670_d() && this.hasMultiblock()) {
            SimpleAltarRecipe recipe;
            if (this.getActiveRecipe() != null) {
                if (this.getActiveRecipe().matches(this, false, false)) {
                    return true;
                }
                this.abortCrafting();
            }
            if ((recipe = this.findRecipe(player)) != null) {
                this.startCrafting(recipe, player);
            }
            return true;
        }
        return false;
    }

    private void gatherStarlight() {
        this.tickStarlightCollectionMap.clear();
        WorldContext ctx = SkyHandler.getContext(this.func_145831_w());
        if (ctx == null) {
            if (this.starlightNextTick > 0) {
                this.starlightNextTick = 0;
                this.markForUpdate();
            }
            return;
        }
        this.starlightNextTick = (int)((float)this.starlightNextTick * 0.9f);
        if (this.doesSeeSky()) {
            int altarTier = this.getAltarType().ordinal() + 1;
            float heightAmount = MathHelper.func_76131_a((float)((float)Math.pow((float)this.func_174877_v().func_177956_o() / 7.0f, 1.5) / 65.0f), (float)0.0f, (float)1.0f);
            this.collectStarlight((heightAmount *= DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w())) * (float)altarTier * 60.0f, AltarCollectionCategory.HEIGHT);
            if (this.posDistribution == -1.0f) {
                this.posDistribution = this.field_145850_b instanceof ISeedReader ? SkyCollectionHelper.getSkyNoiseDistribution((ISeedReader)this.field_145850_b, this.field_174879_c) : 0.3f;
            }
            float fieldAmount = MathHelper.func_76129_c((float)this.posDistribution);
            this.collectStarlight((fieldAmount *= DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w())) * (float)altarTier * 65.0f, AltarCollectionCategory.FOSIC_FIELD);
        }
        this.starlightStorage.setStoredStarlight(this.starlightNextTick);
    }

    public void collectStarlight(float percent, AltarCollectionCategory category) {
        int collectable = MathHelper.func_76141_d((float)Math.min(percent, this.getRemainingCollectionCapacity(category)));
        this.starlightNextTick = MathHelper.func_76125_a((int)(this.starlightNextTick + collectable), (int)0, (int)this.getAltarType().getStarlightCapacity());
        this.tickStarlightCollectionMap.computeIfPresent(category, (cat, remaining) -> Float.valueOf(Math.max(remaining.floatValue() - (float)collectable, 0.0f)));
        this.markForUpdate();
        this.preventNetworkSync();
    }

    public float getRemainingCollectionCapacity(AltarCollectionCategory category) {
        return this.tickStarlightCollectionMap.computeIfAbsent(category, this::getCollectionCap).floatValue();
    }

    public float getCollectionCap(AltarCollectionCategory category) {
        return (float)this.getAltarType().getStarlightCapacity() / 8.5f / (float)this.getAltarType().getMinimumSources();
    }

    @Nonnull
    public Set<BlockPos> nearbyRelays() {
        HashSet<BlockPos> eligableRelayOffsets = new HashSet<BlockPos>();
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                if (xx == 0 && zz == 0) continue;
                BlockPos offset = new BlockPos(xx, 0, zz);
                TileSpectralRelay tar = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177971_a((Vector3i)offset), TileSpectralRelay.class, true);
                if (tar == null) continue;
                eligableRelayOffsets.add(this.func_174877_v().func_177971_a((Vector3i)offset));
            }
        }
        return eligableRelayOffsets;
    }

    @Override
    public void onBreak() {
        super.onBreak();
        if (!this.func_145831_w().func_201670_d() && !this.getFocusItem().func_190926_b()) {
            ItemUtils.dropItemNaturally(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.focusItem);
            this.focusItem = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void onFirstTick() {
        super.onFirstTick();
        this.updateNearbyRelayLinkStates();
    }

    private void updateNearbyRelayLinkStates() {
        Set<BlockPos> relayPositions = BlockDiscoverer.searchForTileEntitiesAround(this.func_145831_w(), this.func_174877_v(), 16, tile -> tile instanceof TileSpectralRelay);
        for (BlockPos relayPos : relayPositions) {
            TileSpectralRelay tsr = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), relayPos, TileSpectralRelay.class, true);
            if (tsr == null) continue;
            tsr.updateAltarLinkState();
        }
    }

    public int getStoredStarlight() {
        return this.starlightStorage.getStoredStarlight();
    }

    public float getAmbientStarlightPercent() {
        return (float)this.getStoredStarlight() / (float)this.getAltarType().getStarlightCapacity();
    }

    public AltarType getAltarType() {
        return this.altarType;
    }

    @Nullable
    public ActiveSimpleAltarRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    @Nonnull
    public ItemStack getFocusItem() {
        return this.focusItem;
    }

    public void setFocusItem(@Nonnull ItemStack focusItem) {
        this.focusItem = focusItem;
        this.markForUpdate();
    }

    @Nullable
    public IConstellation getFocusedConstellation() {
        ItemStack focus = this.getFocusItem();
        if (focus.func_77973_b() instanceof IConstellationFocus) {
            return ((IConstellationFocus)focus.func_77973_b()).getFocusConstellation(focus);
        }
        return null;
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return this.altarType.getRequiredStructure();
    }

    @Nonnull
    public TileInventoryFiltered getInventory() {
        return this.inventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox().func_72321_a(0.0, 5.0, 0.0);
        if (this.getAltarType().isThisGEThan(AltarType.RADIANCE)) {
            box = box.func_72314_b(3.0, 0.0, 3.0);
        }
        return box;
    }

    public <T extends TileAltar> T updateType(AltarType newType, boolean initialPlacement) {
        if (!initialPlacement) {
            this.abortCrafting();
        }
        this.altarType = newType;
        CompoundNBT thisTag = new CompoundNBT();
        this.writeCustomNBT(thisTag);
        this.readCustomNBT(thisTag);
        if (!initialPlacement) {
            this.markForUpdate();
            this.hasMultiblock();
        }
        return (T)this;
    }

    @Override
    public void readNetNBT(CompoundNBT compound) {
        super.readNetNBT(compound);
        this.starlightStorage.readNBT(compound);
    }

    @Override
    public void writeNetNBT(CompoundNBT compound) {
        super.writeNetNBT(compound);
        this.starlightStorage.writeNBT(compound);
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.altarType = AltarType.values()[compound.func_74762_e("altarType")];
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
        this.focusItem = NBTHelper.getStack(compound, "focusItem");
        this.knownRecipes = NBTHelper.readSet(compound, "knownRecipes", 8, nbt -> new ResourceLocation(nbt.func_150285_a_()));
        this.activeRecipe = compound.func_150297_b("activeRecipe", 10) ? ActiveSimpleAltarRecipe.deserialize(compound.func_74775_l("activeRecipe"), this.activeRecipe) : null;
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("altarType", this.altarType.ordinal());
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        NBTHelper.setStack(compound, "focusItem", this.focusItem);
        NBTHelper.writeList(compound, "knownRecipes", this.knownRecipes, key -> StringNBT.func_229705_a_((String)key.toString()));
        if (this.activeRecipe != null) {
            compound.func_218657_a("activeRecipe", (INBT)this.activeRecipe.serialize());
        }
    }

    @Override
    @Nonnull
    public StarlightReceiverAltar provideEndpoint(BlockPos at) {
        return new StarlightReceiverAltar(at);
    }
}

