/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.util.block.BlockStateHelper;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BlockMatchInformation
implements Predicate<BlockState> {
    private final ItemStack display;
    private BlockState matchState;
    private boolean matchExact;
    private ITag<Block> matchTag;
    private ResourceLocation matchTagKey;

    public BlockMatchInformation(ITag<Block> matchTag) {
        this(matchTag, BlockMatchInformation.createDisplayStack(matchTag));
    }

    public BlockMatchInformation(ITag<Block> matchTag, ItemStack display) {
        this.matchTag = matchTag;
        this.matchTagKey = TagCollectionManager.func_242178_a().func_241835_a().func_232973_a_(matchTag);
        this.display = display;
        if (this.matchTagKey == null) {
            throw new IllegalArgumentException("Unknown block tag name!");
        }
        if (this.display.func_190926_b()) {
            throw new IllegalArgumentException("No display ItemStack passed, and unable to create valid itemstack from block tag " + this.matchTagKey.toString() + "!");
        }
    }

    public BlockMatchInformation(BlockState matchState, boolean matchExact) {
        this(matchState, ItemUtils.createBlockStack(matchState), matchExact);
    }

    public BlockMatchInformation(BlockState matchState, ItemStack display, boolean matchExact) {
        this.matchState = matchState;
        this.display = display;
        this.matchExact = matchExact;
        if (this.display.func_190926_b()) {
            throw new IllegalArgumentException("No display ItemStack passed, and " + matchState.func_177230_c().getRegistryName() + " has no associated ItemBlock!");
        }
    }

    private static ItemStack createDisplayStack(ITag<Block> blockTag) {
        for (Block block : blockTag.func_230236_b_()) {
            ItemStack blockStack = ItemUtils.createBlockStack(block.func_176223_P());
            if (blockStack.func_190926_b()) continue;
            return blockStack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean isValid() {
        return this.matchState == null || !(this.matchState.func_177230_c() instanceof AirBlock);
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.display.func_77946_l();
    }

    @Override
    public boolean test(BlockState state) {
        if (this.matchState != null) {
            return this.matchExact ? BlockUtils.matchStateExact(state, this.matchState) : state.func_177230_c().equals(this.matchState.func_177230_c());
        }
        if (this.matchTag != null) {
            return this.matchTag.func_230235_a_((Object)state.func_177230_c());
        }
        return false;
    }

    public static BlockMatchInformation read(JsonObject object) {
        if (object.has("block")) {
            BlockState state = BlockStateHelper.deserializeObject(object);
            boolean fullyDefined = !BlockStateHelper.isMissingStateInformation(object);
            ItemStack display = new ItemStack((IItemProvider)state.func_177230_c());
            if (object.has("display")) {
                display = JsonHelper.getItemStack(object, "display");
            }
            return new BlockMatchInformation(state, display, fullyDefined);
        }
        if (object.has("tag")) {
            ITag blockTag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(object.get("tag").getAsString()));
            if (object.has("display")) {
                ItemStack display = JsonHelper.getItemStack(object, "display");
                return new BlockMatchInformation((ITag<Block>)blockTag, display);
            }
            return new BlockMatchInformation((ITag<Block>)blockTag);
        }
        throw new JsonSyntaxException("Neither block nor tag defined for block transmutation match information!");
    }

    public JsonObject serializeJson() {
        JsonObject out = new JsonObject();
        if (this.matchState != null) {
            BlockStateHelper.serializeObject(out, this.matchState, this.matchExact);
            out.add("display", (JsonElement)JsonHelper.serializeItemStack(this.getDisplayStack()));
        } else if (this.matchTag != null) {
            out.add("tag", (JsonElement)new JsonPrimitive(this.matchTagKey.toString()));
        }
        return out;
    }

    public static BlockMatchInformation read(PacketBuffer buf) {
        int type = buf.readInt();
        ItemStack display = ByteBufUtils.readItemStack(buf);
        switch (type) {
            case 0: {
                BlockState state = ByteBufUtils.readBlockState(buf);
                boolean exactMatch = buf.readBoolean();
                return new BlockMatchInformation(state, display, exactMatch);
            }
            case 1: {
                String tagName = ByteBufUtils.readString(buf);
                ITag blockTag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(tagName));
                return new BlockMatchInformation((ITag<Block>)blockTag, display);
            }
        }
        throw new IllegalArgumentException("Unknown block transmutation match type: " + type);
    }

    public void serialize(PacketBuffer buf) {
        int type = this.matchState != null ? 0 : 1;
        buf.writeInt(type);
        ByteBufUtils.writeItemStack(buf, this.display);
        switch (type) {
            case 0: {
                ByteBufUtils.writeBlockState(buf, this.matchState);
                buf.writeBoolean(this.matchExact);
                break;
            }
            case 1: {
                ByteBufUtils.writeString(buf, this.matchTagKey.toString());
            }
        }
    }
}

