/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.data;

import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.fluids.FluidStack;

public class ASDataSerializers {
    public static IDataSerializer<Long> LONG = new IDataSerializer<Long>(){

        public void write(PacketBuffer buf, Long value) {
            buf.writeLongLE(value.longValue());
        }

        public Long read(PacketBuffer buf) {
            return buf.readLongLE();
        }

        public DataParameter<Long> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Long copyValue(Long value) {
            return new Long(value);
        }
    };
    public static IDataSerializer<Vector3> VECTOR = new IDataSerializer<Vector3>(){

        public void write(PacketBuffer buf, Vector3 value) {
            buf.writeDouble(value.getX());
            buf.writeDouble(value.getY());
            buf.writeDouble(value.getZ());
        }

        public Vector3 read(PacketBuffer buf) {
            return new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public DataParameter<Vector3> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Vector3 copyValue(Vector3 value) {
            return value.clone();
        }
    };
    public static IDataSerializer<FluidStack> FLUID = new IDataSerializer<FluidStack>(){

        public void write(PacketBuffer buf, FluidStack value) {
            ByteBufUtils.writeFluidStack(buf, value);
        }

        public FluidStack read(PacketBuffer buf) {
            return ByteBufUtils.readFluidStack(buf);
        }

        public DataParameter<FluidStack> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public FluidStack copyValue(FluidStack value) {
            return value.copy();
        }
    };
}

