/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.tile;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class PrecisionSingleFluidTank
implements IFluidTank {
    private double amount = 0.0;
    private int maxCapacity;
    private Fluid fluid = Fluids.field_204541_a;
    private Runnable onUpdate;
    private boolean allowInput;
    private boolean allowOutput;

    private PrecisionSingleFluidTank() {
        this.onUpdate = () -> {};
        this.allowInput = true;
        this.allowOutput = true;
    }

    public PrecisionSingleFluidTank(int maxCapacity) {
        this.onUpdate = () -> {};
        this.allowInput = true;
        this.allowOutput = true;
        this.maxCapacity = maxCapacity;
    }

    public void addUpdateFunction(Runnable onUpdate) {
        Runnable prevRunnable = this.onUpdate;
        this.onUpdate = () -> {
            prevRunnable.run();
            onUpdate.run();
        };
    }

    public void setAllowInput(boolean allowInput) {
        this.allowInput = allowInput;
    }

    public void setAllowOutput(boolean allowOutput) {
        this.allowOutput = allowOutput;
    }

    public double getMaxAddable(double toAdd) {
        return Math.min(toAdd, (double)this.maxCapacity - this.amount);
    }

    public int getMaxDrainable(double toDrain) {
        return (int)Math.floor(Math.min(toDrain, this.amount));
    }

    public double addAmount(double amount) {
        if (this.fluid == Fluids.field_204541_a) {
            return amount;
        }
        double addable = this.getMaxAddable(amount);
        this.amount += addable;
        if (Math.abs(addable) > 0.0) {
            this.onUpdate.run();
        }
        return amount - addable;
    }

    @Nonnull
    public FluidStack drain(double amount) {
        if (this.fluid == Fluids.field_204541_a) {
            return FluidStack.EMPTY;
        }
        int drainable = this.getMaxDrainable(amount);
        this.amount -= (double)drainable;
        Fluid drainedFluid = this.fluid;
        if (this.amount <= 0.0) {
            this.setFluid(Fluids.field_204541_a);
        }
        if (Math.abs(drainable) > 0) {
            this.onUpdate.run();
        }
        return new FluidStack(drainedFluid, drainable);
    }

    @Nonnull
    public FluidStack getFluid() {
        if (this.fluid == Fluids.field_204541_a) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.fluid, this.getFluidAmount());
    }

    public void setFluid(@Nonnull Fluid fluid) {
        boolean update = false;
        if (fluid != this.fluid) {
            this.amount = 0.0;
            update = true;
        }
        this.fluid = fluid;
        if (update) {
            this.onUpdate.run();
        }
    }

    public int getFluidAmount() {
        return MathHelper.func_76128_c((double)this.amount);
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public boolean canFill() {
        return this.allowInput && this.amount < (double)this.maxCapacity;
    }

    public boolean canDrain() {
        return this.allowOutput && this.amount > 0.0 && this.fluid != Fluids.field_204541_a;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill() && (this.fluid == Fluids.field_204541_a || fluidStack.getFluid().equals(this.fluid));
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain() && this.fluid != Fluids.field_204541_a && fluidStack.getFluid().equals(this.fluid);
    }

    public float getPercentageFilled() {
        return (float)this.amount / (float)this.maxCapacity;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        int maxAdded = resource.getAmount();
        int addable = MathHelper.func_76128_c((double)this.getMaxAddable(maxAdded));
        if (action.execute()) {
            if (addable > 0 && this.fluid == Fluids.field_204541_a) {
                this.setFluid(resource.getFluid());
            }
            addable = (int)((double)addable - this.addAmount(addable));
        }
        return addable;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.canDrain()) {
            return FluidStack.EMPTY;
        }
        int maxDrainable = this.getMaxDrainable(maxDrain);
        if (action.execute()) {
            return this.drain(maxDrainable);
        }
        return new FluidStack(this.fluid, maxDrainable);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrainFluidType(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public CompoundNBT writeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("amt", this.amount);
        tag.func_74768_a("capacity", this.maxCapacity);
        tag.func_74757_a("aIn", this.allowInput);
        tag.func_74757_a("aOut", this.allowOutput);
        tag.func_74778_a("fluid", this.fluid.getRegistryName().toString());
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        this.amount = tag.func_74769_h("amt");
        this.maxCapacity = tag.func_74762_e("capacity");
        this.allowInput = tag.func_74767_n("aIn");
        this.allowOutput = tag.func_74767_n("aOut");
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("fluid")));
    }

    public static PrecisionSingleFluidTank deserialize(CompoundNBT tag) {
        PrecisionSingleFluidTank tank = new PrecisionSingleFluidTank();
        tank.readNBT(tag);
        return tank;
    }
}

