/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.blocks;

import com.thevortex.potionsmaster.entity.TileEntityCauldron;
import com.thevortex.potionsmaster.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.command.TextComponentHelper;

public class Cauldron
extends CauldronBlock {
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208130_ae;
    public VoxelShape blockshape = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);

    public Cauldron() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185851_d).func_200943_b(2.0f));
        this.func_180632_j((BlockState)((Block)this.func_176194_O().func_177622_c()).func_176223_P().func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(World world, BlockPos worldIn, int intensity) {
        Random random = world.field_73012_v;
        for (Direction direction : Direction.values()) {
            double d3;
            BlockPos blockpos = worldIn.func_177971_a(direction.func_176730_m());
            if (world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d = d3 = direction$axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
            if (intensity != 3) continue;
            world.func_195594_a((IParticleData)new RedstoneParticleData(0.0f, 1.0f, 0.0f, 1.0f), (double)worldIn.func_177958_n() + d1, (double)worldIn.func_177956_o() + d2, (double)worldIn.func_177952_p() + d3, 0.0, 0.0, 0.0);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState state2, boolean update) {
        if (!(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof CampfireBlock) && state.func_177230_c() instanceof Cauldron) {
            worldIn.func_175655_b(pos, true);
        }
        super.func_220082_b(state, worldIn, pos, state2, true);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (!worldIn.field_72995_K) {
            ServerPlayerEntity player2 = (ServerPlayerEntity)player;
            ItemStack itemstack = player2.func_184586_b(handIn);
            TileEntityCauldron cauldron = (TileEntityCauldron)worldIn.func_175625_s(pos);
            if (itemstack.func_190926_b()) {
                cauldron.resetAll();
                return ActionResultType.PASS;
            }
            int i = (Integer)state.func_177229_b((Property)LEVEL);
            if (i == 3) {
                return ActionResultType.PASS;
            }
            Item item = itemstack.func_77973_b();
            Cauldron cauldronBlock = (Cauldron)worldIn.func_180495_p(pos).func_177230_c();
            if (item == Items.field_151068_bn) {
                List effects = PotionUtils.func_185185_a((CompoundNBT)itemstack.func_77978_p());
                if (effects.isEmpty()) {
                    return ActionResultType.PASS;
                }
                if (!cauldron.INPUT_A.isEmpty() && !cauldron.INPUT_B.isEmpty()) {
                    return ActionResultType.PASS;
                }
                if (cauldron.INPUT_A.isEmpty()) {
                    for (EffectInstance e : effects) {
                        cauldron.INPUT_A.add(e);
                    }
                    ItemStack itemstack3 = new ItemStack((IItemProvider)Items.field_151069_bo);
                    player2.func_184611_a(handIn, itemstack3);
                    cauldronBlock.func_176590_a(worldIn, pos, state, 1);
                    return ActionResultType.SUCCESS;
                }
                if (!cauldron.INPUT_A.isEmpty() && cauldron.INPUT_B.isEmpty()) {
                    for (EffectInstance e : effects) {
                        cauldron.INPUT_B.add(e);
                    }
                    ItemStack itemstack3 = new ItemStack((IItemProvider)Items.field_151069_bo);
                    player2.func_184611_a(handIn, itemstack3);
                    cauldron.goForReady();
                    cauldronBlock.func_176590_a(worldIn, pos, state, 2);
                    return ActionResultType.SUCCESS;
                }
            }
            if (!cauldron.INPUT_A.isEmpty() && item == Items.field_151114_aO && !cauldron.INPUT_B.isEmpty()) {
                cauldron.goForReady();
                itemstack.func_190920_e(itemstack.func_190916_E() - 1);
                cauldron.giveCatalyst();
                cauldronBlock.func_176590_a(worldIn, pos, state, 3);
                cauldron.startBrewing();
            }
            if (item == Items.field_151069_bo && cauldron.isComplete()) {
                ItemStack itemstack2 = new ItemStack((IItemProvider)Items.field_151068_bn);
                List<EffectInstance> effects = cauldron.getOutput();
                PotionUtils.func_185184_a((ItemStack)itemstack2, effects);
                itemstack2.func_200302_a((ITextComponent)TextComponentHelper.createComponentTranslation((ICommandSource)player2, (String)"Blended Potion", (Object[])new Object[]{new Object()}));
                player2.func_184611_a(handIn, itemstack2.func_77946_l());
                cauldronBlock.func_176590_a(worldIn, pos, state, i - 1);
                cauldron.resetAll();
            }
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.blockshape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((TileEntityCauldron)worldIn.func_175625_s(pos)).isComplete()) {
            Cauldron.spawnParticles(worldIn, pos, (Integer)stateIn.func_177229_b((Property)LEVEL));
        }
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((IItemProvider)ModItems.ITEM_CAULDRON));
        return list;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityCauldron((World)world, state);
    }
}

