/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import it.hurts.sskirillss.relics.api.durability.IRepairableItem;
import it.hurts.sskirillss.relics.api.leveling.ILeveledItem;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.RelicsConfig;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipDescriptionHandler {
    @SubscribeEvent
    public static void onTooltipRender(ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        List original = event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (!(stack.func_77973_b() instanceof RelicItem)) {
            return;
        }
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        TooltipDescriptionHandler.renderState(stack, tooltip, player);
        TooltipDescriptionHandler.renderShift(stack, tooltip);
        try {
            if (event.getFlags() == ITooltipFlag.TooltipFlags.ADVANCED) {
                original.remove(new TranslationTextComponent("item.durability", new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        original.addAll(1, tooltip);
    }

    private static void renderState(ItemStack stack, List<ITextComponent> tooltip, PlayerEntity player) {
        if (player == null || stack == null) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IRepairableItem) {
            if (DurabilityUtils.isBroken(stack)) {
                tooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.relic.broken").func_240699_a_(TextFormatting.YELLOW)));
            } else if ((float)stack.func_77952_i() >= (float)stack.func_77958_k() * 0.1f) {
                tooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.relic.damaged").func_240699_a_(TextFormatting.YELLOW)));
            }
        }
        for (String tag : CuriosApi.getCuriosHelper().getCurioTags(item)) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                if (curios.size() == 0) {
                    return;
                }
                ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
                if (curios.get(tag) == null || ((ICurioStacksHandler)curios.get(tag)).getSlots() > 0) {
                    return;
                }
                for (Item item : ItemRegistry.getSlotModifiers()) {
                    RelicItem relic = (RelicItem)item;
                    for (Pair<String, Integer> pair : relic.getSlotModifiers(stack).getModifiers()) {
                        String identifier = (String)pair.getLeft();
                        int amount = (Integer)pair.getRight();
                        if (!identifier.equals(tag) || amount <= 0) continue;
                        list.add(new StringTextComponent("   \u25c6 ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new StringTextComponent(new ItemStack((IItemProvider)item).func_200301_q().getString()).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" [+%d]", amount)).func_240699_a_(TextFormatting.WHITE)));
                    }
                }
                StringTextComponent info = new StringTextComponent("");
                info.func_230529_a_((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.relic.requires_slot").func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("curios.identifier." + tag).func_240699_a_(TextFormatting.GREEN)));
                if (!list.isEmpty()) {
                    info.func_240702_b_(". ").func_240699_a_(TextFormatting.YELLOW).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.relic.allowed_modifiers").func_240699_a_(TextFormatting.YELLOW));
                }
                tooltip.add((ITextComponent)info);
                if (!list.isEmpty()) {
                    tooltip.addAll(list);
                }
            });
        }
    }

    private static List<ITextComponent> getSlotTooltip(ItemStack stack) {
        ArrayList tags = new ArrayList(CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b()));
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (!(stack.func_77973_b() instanceof ICurioItem) || tags.isEmpty()) {
            return tooltip;
        }
        StringTextComponent component = new StringTextComponent("");
        component.func_230529_a_((ITextComponent)new StringTextComponent("   \u25c6 ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.stats.slot").func_240699_a_(TextFormatting.YELLOW)).func_240702_b_(" "));
        for (int i = 0; i < tags.size(); ++i) {
            String tag = (String)tags.get(i);
            component.func_230529_a_((ITextComponent)new TranslationTextComponent("curios.identifier." + tag).func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent(i + 1 < tags.size() ? ", " : "").func_240699_a_(TextFormatting.GRAY)));
        }
        tooltip.add((ITextComponent)component);
        return tooltip;
    }

    private static List<ITextComponent> getLevelingTooltip(ItemStack stack) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (!(stack.func_77973_b() instanceof ILeveledItem)) {
            return tooltip;
        }
        ILeveledItem item = (ILeveledItem)stack.func_77973_b();
        int level = item.getLevel(stack);
        int currExp = item.getExperience(stack);
        int prevExp = item.getTotalExperienceForLevel(Math.max(level, level - 1));
        int nextExp = item.getTotalExperienceForLevel(item.getLevel(stack) + 1);
        tooltip.add((ITextComponent)new StringTextComponent("   \u25c6 ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.stats.level").func_240699_a_(TextFormatting.YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%d [%d/%d]", level, currExp - prevExp, nextExp - prevExp)).func_240699_a_(TextFormatting.WHITE)));
        return tooltip;
    }

    private static List<ITextComponent> getDurabilityTooltip(ItemStack stack) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (!(stack.func_77973_b() instanceof IRepairableItem) || DurabilityUtils.isBroken(stack) || !((Boolean)RelicsConfig.ENABLE_RELICS_DURABILITY.get()).booleanValue()) {
            return tooltip;
        }
        tooltip.add((ITextComponent)new StringTextComponent("   \u25c6 ").func_240699_a_(TextFormatting.GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.stats.durability").func_240699_a_(TextFormatting.YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %d/%d", DurabilityUtils.getDurability(stack), stack.func_77958_k())).func_240699_a_(TextFormatting.WHITE)));
        return tooltip;
    }

    private static List<ITextComponent> getAbilitiesTooltip(ItemStack stack) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (!(stack.func_77973_b() instanceof RelicItem)) {
            return tooltip;
        }
        RelicItem relic = (RelicItem)stack.func_77973_b();
        RelicTooltip data = relic.getTooltip(stack);
        if (data == null) {
            return tooltip;
        }
        List<AbilityTooltip> abilities = data.getAbilities();
        if (abilities.isEmpty()) {
            return tooltip;
        }
        for (int i = 0; i < abilities.size(); ++i) {
            AbilityTooltip ability = abilities.get(i);
            String path = "tooltip.relics." + Objects.requireNonNull(relic.getRegistryName()).func_110623_a() + ".ability." + (i + 1) + ".";
            String key = ability.getKeybinding();
            tooltip.add((ITextComponent)new StringTextComponent("   \u25c6 ").func_240699_a_(ability.isNegative() ? TextFormatting.RED : TextFormatting.GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent(path + "name").func_240699_a_(TextFormatting.YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent(key == null ? "" : String.format(" [%s]", key)).func_240699_a_(TextFormatting.DARK_GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(" - ").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new TranslationTextComponent(path + "description", ability.getArgs().toArray(new Object[0])).func_240699_a_(TextFormatting.GRAY)));
        }
        return tooltip;
    }

    private static List<ITextComponent> getModifiersTooltip(ItemStack stack) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (!(stack.func_77973_b() instanceof RelicItem)) {
            return tooltip;
        }
        RelicItem relic = (RelicItem)stack.func_77973_b();
        if (relic.getSlotModifiers(stack) == null) {
            return tooltip;
        }
        for (Pair<String, Integer> pair : relic.getSlotModifiers(stack).getModifiers()) {
            String identifier = (String)pair.getLeft();
            int amount = (Integer)pair.getRight();
            tooltip.add((ITextComponent)new StringTextComponent("   \u25c6 ").func_240699_a_(amount > 0 ? TextFormatting.GREEN : TextFormatting.RED).func_230529_a_((ITextComponent)new TranslationTextComponent("curios.identifier." + identifier).func_240699_a_(TextFormatting.YELLOW)).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" [%s%s]", amount > 0 ? "+" : "-", amount)).func_240699_a_(TextFormatting.GRAY)));
        }
        return tooltip;
    }

    private static void renderShift(ItemStack stack, List<ITextComponent> tooltip) {
        boolean hasStats;
        List<ITextComponent> slot = TooltipDescriptionHandler.getSlotTooltip(stack);
        List<ITextComponent> leveling = TooltipDescriptionHandler.getLevelingTooltip(stack);
        List<ITextComponent> abilities = TooltipDescriptionHandler.getAbilitiesTooltip(stack);
        List<ITextComponent> modifiers = TooltipDescriptionHandler.getModifiersTooltip(stack);
        List<ITextComponent> durability = TooltipDescriptionHandler.getDurabilityTooltip(stack);
        boolean bl = hasStats = !leveling.isEmpty() || !durability.isEmpty() || !slot.isEmpty();
        if (hasStats || !abilities.isEmpty() || !modifiers.isEmpty()) {
            if (Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                if (!abilities.isEmpty()) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.abilities").func_240699_a_(TextFormatting.GREEN)));
                    tooltip.addAll(abilities);
                    if (hasStats) {
                        tooltip.add((ITextComponent)new StringTextComponent(" "));
                    }
                }
                if (hasStats) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.stats").func_240699_a_(TextFormatting.GREEN)));
                    tooltip.addAll(slot);
                    tooltip.addAll(leveling);
                    tooltip.addAll(durability);
                    if (!modifiers.isEmpty()) {
                        tooltip.add((ITextComponent)new StringTextComponent(" "));
                    }
                }
                if (!modifiers.isEmpty()) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u25b6 ").func_240699_a_(TextFormatting.DARK_GREEN).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.slots").func_240699_a_(TextFormatting.GREEN)));
                    tooltip.addAll(modifiers);
                }
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.shift.title"));
            }
        }
    }
}

