/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip.base;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class RelicTooltip {
    private List<AbilityTooltip> abilities;
    private Pair<String, String> borders;

    RelicTooltip(List<AbilityTooltip> abilities, Pair<String, String> borders) {
        this.abilities = abilities;
        this.borders = borders;
    }

    public static RelicTooltipBuilder builder() {
        return new RelicTooltipBuilder();
    }

    public List<AbilityTooltip> getAbilities() {
        return this.abilities;
    }

    public Pair<String, String> getBorders() {
        return this.borders;
    }

    public void setAbilities(List<AbilityTooltip> abilities) {
        this.abilities = abilities;
    }

    public void setBorders(Pair<String, String> borders) {
        this.borders = borders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicTooltip)) {
            return false;
        }
        RelicTooltip other = (RelicTooltip)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AbilityTooltip> this$abilities = this.getAbilities();
        List<AbilityTooltip> other$abilities = other.getAbilities();
        if (this$abilities == null ? other$abilities != null : !((Object)this$abilities).equals(other$abilities)) {
            return false;
        }
        Pair<String, String> this$borders = this.getBorders();
        Pair<String, String> other$borders = other.getBorders();
        return !(this$borders == null ? other$borders != null : !this$borders.equals(other$borders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelicTooltip;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbilityTooltip> $abilities = this.getAbilities();
        result = result * 59 + ($abilities == null ? 43 : ((Object)$abilities).hashCode());
        Pair<String, String> $borders = this.getBorders();
        result = result * 59 + ($borders == null ? 43 : $borders.hashCode());
        return result;
    }

    public String toString() {
        return "RelicTooltip(abilities=" + this.getAbilities() + ", borders=" + this.getBorders() + ")";
    }

    public static class RelicTooltipBuilder {
        private ArrayList<AbilityTooltip> abilities;
        private Pair<String, String> borders;

        public RelicTooltipBuilder borders(String top, String bottom) {
            this.borders = Pair.of((Object)top, (Object)bottom);
            return this;
        }

        RelicTooltipBuilder() {
        }

        public RelicTooltipBuilder ability(AbilityTooltip ability) {
            if (this.abilities == null) {
                this.abilities = new ArrayList();
            }
            this.abilities.add(ability);
            return this;
        }

        public RelicTooltipBuilder abilities(Collection<? extends AbilityTooltip> abilities) {
            if (abilities == null) {
                throw new NullPointerException("abilities cannot be null");
            }
            if (this.abilities == null) {
                this.abilities = new ArrayList();
            }
            this.abilities.addAll(abilities);
            return this;
        }

        public RelicTooltipBuilder clearAbilities() {
            if (this.abilities != null) {
                this.abilities.clear();
            }
            return this;
        }

        public RelicTooltip build() {
            List<AbilityTooltip> abilities;
            switch (this.abilities == null ? 0 : this.abilities.size()) {
                case 0: {
                    abilities = Collections.emptyList();
                    break;
                }
                case 1: {
                    abilities = Collections.singletonList(this.abilities.get(0));
                    break;
                }
                default: {
                    abilities = Collections.unmodifiableList(new ArrayList<AbilityTooltip>(this.abilities));
                }
            }
            return new RelicTooltip(abilities, this.borders);
        }

        public String toString() {
            return "RelicTooltip.RelicTooltipBuilder(abilities=" + this.abilities + ", borders=" + this.borders + ")";
        }
    }
}

