/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.configs;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import it.hurts.sskirillss.relics.configs.ConfigHelper;
import it.hurts.sskirillss.relics.configs.RelicsConfig;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.configs.data.runes.RuneConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class ExtendedRelicsConfig {
    private static Date launchDate;

    public static void setupExtendedConfigs() {
        launchDate = new Date();
        ExtendedRelicsConfig.setupRelicsConfigs();
        ExtendedRelicsConfig.setupRunesConfigs();
    }

    private static void setupRelicsConfigs() {
        Path rootPath = ConfigHelper.getRootPath().resolve("items").resolve("relics");
        ItemRegistry.getRegisteredRelics().forEach(relic -> {
            RelicConfigData data;
            if (!((Boolean)RelicsConfig.ENABLE_EXTENDED_CONFIG.get()).booleanValue()) {
                relic.setConfig(relic.getConfigData());
                return;
            }
            String path = Objects.requireNonNull(relic.getRegistryName()).func_110623_a() + ".json";
            try {
                data = (RelicConfigData)ConfigHelper.readJSONConfig(rootPath.resolve(path), TypeToken.getParameterized(RelicConfigData.class, (Type[])new Type[]{relic.getConfigData().getStats() == null ? RelicStats.class : relic.getConfigData().getStats().getClass()}).getType());
            }
            catch (JsonSyntaxException e) {
                data = null;
            }
            if (data == null) {
                Path sourcePath = rootPath.resolve(path);
                if (Files.exists(sourcePath, new LinkOption[0])) {
                    Path backupPath = rootPath.resolve("backups").resolve(new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(launchDate)).resolve(rootPath.relativize(sourcePath)).getParent();
                    try {
                        Files.createDirectories(backupPath, new FileAttribute[0]);
                        Files.move(sourcePath, backupPath.resolve(path), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Files.createDirectories(rootPath, new FileAttribute[0]);
                    ConfigHelper.createJSONConfig(sourcePath, relic.getConfigData());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                data = relic.getConfigData();
            }
            relic.setConfig(data);
        });
    }

    private static void setupRunesConfigs() {
        Path rootPath = ConfigHelper.getRootPath().resolve("items").resolve("runes");
        ItemRegistry.getRegisteredRunes().forEach(rune -> {
            RuneConfigData data;
            if (!((Boolean)RelicsConfig.ENABLE_EXTENDED_CONFIG.get()).booleanValue()) {
                rune.setConfig(rune.getConfigData());
                return;
            }
            String path = Objects.requireNonNull(rune.getRegistryName()).func_110623_a() + ".json";
            try {
                data = (RuneConfigData)ConfigHelper.readJSONConfig(rootPath.resolve(path), RuneConfigData.class);
            }
            catch (JsonSyntaxException e) {
                data = null;
            }
            if (data == null) {
                Path sourcePath = rootPath.resolve(path);
                if (Files.exists(sourcePath, new LinkOption[0])) {
                    Path backupPath = rootPath.resolve("backups").resolve(new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(launchDate)).resolve(rootPath.relativize(sourcePath)).getParent();
                    try {
                        Files.createDirectories(backupPath, new FileAttribute[0]);
                        Files.move(sourcePath, backupPath.resolve(path), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Files.createDirectories(rootPath, new FileAttribute[0]);
                    ConfigHelper.createJSONConfig(sourcePath, rune.getConfigData());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                data = rune.getConfigData();
            }
            rune.setConfig(data);
        });
    }
}

