/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.crafting;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.RecipeRegistry;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicUtils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RelicOwnerRecipe
extends SpecialRecipe {
    public RelicOwnerRecipe(ResourceLocation location) {
        super(location);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundContract = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ItemRegistry.RELIC_CONTRACT.get() && NBTUtils.getInt(stack, "blood", 0) >= 4 && !RelicUtils.Owner.getOwnerUUID(stack).equals("") && !foundContract) {
                foundContract = true;
                continue;
            }
            if (!foundItem) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundItem && foundContract;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inv) {
        ItemStack item = ItemStack.field_190927_a;
        ItemStack contract = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (contract.func_190926_b() && stack.func_77973_b() == ItemRegistry.RELIC_CONTRACT.get()) {
                contract = stack;
                continue;
            }
            if (!item.func_190926_b()) continue;
            item = stack;
        }
        if (item.func_190926_b() || contract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = item.func_77946_l().func_77979_a(1);
        RelicUtils.Owner.setOwnerUUID(result, RelicUtils.Owner.getOwnerUUID(contract));
        NBTUtils.setLong(result, "date", 0L);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 || height > 1;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeRegistry.RELIC_OWNER.get();
    }
}

