/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.client.particles.spark.SparkTintData;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.SpaceDissectorItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpaceDissectorEntity
extends ThrowableEntity {
    private static final DataParameter<Integer> UPDATE_TIME = EntityDataManager.func_187226_a(SpaceDissectorEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> IS_RETURNING = EntityDataManager.func_187226_a(SpaceDissectorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(SpaceDissectorEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNER = EntityDataManager.func_187226_a(SpaceDissectorEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final String TAG_UPDATE_TIME = "time";
    private static final String TAG_IS_RETURNING = "returning";
    private static final String TAG_BOUNCES_AMOUNT = "bounces";
    private static final String TAG_OWNER_UUID = "owner";
    private static boolean bounced = false;
    public ItemStack stack = ItemStack.field_190927_a;
    private PlayerEntity owner;
    private static int time;

    public SpaceDissectorEntity(EntityType<? extends SpaceDissectorEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public SpaceDissectorEntity(World world, LivingEntity throwerIn) {
        super((EntityType)EntityRegistry.SPACE_DISSECTOR.get(), throwerIn, world);
    }

    public void setOwner(PlayerEntity playerIn) {
        this.owner = playerIn;
        if (playerIn != null) {
            this.field_70180_af.func_187227_b(OWNER, (Object)playerIn.func_110124_au().toString());
        }
    }

    public void func_70071_h_() {
        Vector3d defaultMotion = this.func_213322_ci();
        super.func_70071_h_();
        SpaceDissectorItem.Stats config = (SpaceDissectorItem.Stats)SpaceDissectorItem.INSTANCE.getStats();
        for (int i = 0; i < 3; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new SparkTintData(new Color(255 - this.field_70146_Z.nextInt(100), 0, 255 - this.field_70146_Z.nextInt(100)), 0.2f, 30), this.field_70169_q, this.field_70167_r, this.field_70166_s, (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.01f), 0.0, (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.01f));
        }
        if (!this.field_70170_p.func_201670_d() && this.field_70173_aa % 20 == 0) {
            if ((Integer)this.field_70180_af.func_187225_a(UPDATE_TIME) > config.maxThrownTime) {
                if (this.owner != null && this.stack != null && !this.stack.func_190926_b()) {
                    NBTUtils.setBoolean(this.stack, "thrown", false);
                }
                this.func_70106_y();
            }
            if (!((Boolean)this.field_70180_af.func_187225_a(IS_RETURNING)).booleanValue()) {
                if ((Integer)this.field_70180_af.func_187225_a(UPDATE_TIME) < config.timeBeforeReturn) {
                    this.field_70180_af.func_187227_b(UPDATE_TIME, (Object)((Integer)this.field_70180_af.func_187225_a(UPDATE_TIME) + 1));
                } else {
                    this.field_70180_af.func_187227_b(IS_RETURNING, (Object)true);
                }
            }
        }
        if (!((Boolean)this.field_70180_af.func_187225_a(IS_RETURNING)).booleanValue()) {
            if (!bounced) {
                this.func_213317_d(defaultMotion);
            }
        } else if (!this.field_70170_p.func_201670_d()) {
            if (this.owner != null) {
                EntityUtils.moveTowardsPosition((Entity)this, new Vector3d(this.owner.func_226277_ct_(), this.owner.func_226278_cu_() + 1.0, this.owner.func_226281_cx_()), config.projectileSpeed);
                for (PlayerEntity player : this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(2.0))) {
                    if (!this.owner.func_110124_au().equals(player.func_110124_au()) || this.stack == null || this.stack.func_190926_b()) continue;
                    this.func_70106_y();
                    NBTUtils.setBoolean(this.stack, "thrown", false);
                }
            } else {
                if (this.stack != null && this.stack != ItemStack.field_190927_a) {
                    NBTUtils.setBoolean(this.stack, "thrown", false);
                }
                this.func_70106_y();
            }
        }
        if (this.func_70027_ad()) {
            this.func_70066_B();
        }
        ++time;
        bounced = false;
    }

    protected void func_70227_a(@Nonnull RayTraceResult rayTraceResult) {
        SpaceDissectorItem.Stats config = (SpaceDissectorItem.Stats)SpaceDissectorItem.INSTANCE.getStats();
        switch (rayTraceResult.func_216346_c()) {
            case BLOCK: {
                BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
                if (!this.field_70170_p.func_180495_p(result.func_216350_a()).func_185904_a().func_76230_c()) {
                    return;
                }
                if ((Integer)this.field_70180_af.func_187225_a(BOUNCES) < config.maxBounces) {
                    if (((Boolean)this.field_70180_af.func_187225_a(IS_RETURNING)).booleanValue()) {
                        return;
                    }
                    Direction dir = result.func_216354_b();
                    Vector3d normalVector = new Vector3d((double)(-2 * dir.func_82601_c()), (double)(-2 * dir.func_96559_d()), (double)(-2 * dir.func_82599_e())).func_72432_b();
                    double delta = -1.91 * this.func_213322_ci().func_72430_b(normalVector);
                    this.func_213317_d(normalVector.func_216372_d(delta, delta, delta).func_178787_e(this.func_213322_ci()));
                    for (int i = 0; i < 20; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)new SparkTintData(new Color(255, 255 - this.field_70146_Z.nextInt(50), 0), 0.15f, this.field_70146_Z.nextInt(7) + 1), this.func_226277_ct_() + (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.25f), this.func_226278_cu_() + (double)0.1f, this.func_226281_cx_() + (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.25f), this.func_213322_ci().field_72450_a * 1.25 + (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.35f), this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c * 1.25 + (double)(MathUtils.randomFloat(this.field_70146_Z) * 0.35f));
                    }
                    if (time > 2) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundRegistry.RICOCHET, SoundCategory.MASTER, 0.5f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
                        time = 0;
                    }
                    bounced = true;
                    this.field_70180_af.func_187227_b(BOUNCES, (Object)((Integer)this.field_70180_af.func_187225_a(BOUNCES) + 1));
                    this.field_70180_af.func_187227_b(UPDATE_TIME, (Object)Math.max((Integer)this.field_70180_af.func_187225_a(UPDATE_TIME) - config.additionalTimeAfterBounce, 0));
                    break;
                }
                this.field_70180_af.func_187227_b(IS_RETURNING, (Object)true);
                break;
            }
            case ENTITY: {
                EntityRayTraceResult result = (EntityRayTraceResult)rayTraceResult;
                if (!(result.func_216348_a() instanceof LivingEntity)) {
                    return;
                }
                LivingEntity entity = (LivingEntity)result.func_216348_a();
                if (this.owner != null && this.owner.func_110124_au().equals(entity.func_110124_au())) {
                    if (this.stack != null && this.stack != ItemStack.field_190927_a) {
                        NBTUtils.setBoolean(this.stack, "thrown", false);
                    }
                    this.func_70106_y();
                    break;
                }
                entity.func_70097_a(this.owner != null ? DamageSource.func_76365_a((PlayerEntity)this.owner) : DamageSource.field_76377_j, (float)config.baseDamage + (float)((Integer)this.field_70180_af.func_187225_a(BOUNCES)).intValue() * config.damageMultiplierPerBounce);
                break;
            }
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(UPDATE_TIME, (Object)0);
        this.field_70180_af.func_187214_a(IS_RETURNING, (Object)false);
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(OWNER, (Object)"");
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_74768_a(TAG_UPDATE_TIME, ((Integer)this.field_70180_af.func_187225_a(UPDATE_TIME)).intValue());
        tag.func_74778_a(TAG_OWNER_UUID, (String)this.field_70180_af.func_187225_a(OWNER));
        tag.func_74757_a(TAG_IS_RETURNING, ((Boolean)this.field_70180_af.func_187225_a(IS_RETURNING)).booleanValue());
        tag.func_74768_a(TAG_BOUNCES_AMOUNT, ((Integer)this.field_70180_af.func_187225_a(BOUNCES)).intValue());
        this.stack.func_77955_b(tag);
        super.func_213281_b(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(UPDATE_TIME, (Object)tag.func_74762_e(TAG_UPDATE_TIME));
        this.field_70180_af.func_187227_b(OWNER, (Object)tag.func_74779_i(TAG_OWNER_UUID));
        this.field_70180_af.func_187227_b(IS_RETURNING, (Object)tag.func_74767_n(TAG_IS_RETURNING));
        this.field_70180_af.func_187227_b(BOUNCES, (Object)tag.func_74762_e(TAG_BOUNCES_AMOUNT));
        this.stack = ItemStack.func_199557_a((CompoundNBT)tag);
        super.func_70037_a(tag);
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

