/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.curios.api.SlotContext;

public class HorseFluteItem
extends RelicItem<Stats> {
    private static final String TAG_ENTITY = "entity";
    private static final String TAG_UUID = "uuid";

    public HorseFluteItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#eed551", "#dcbe1d").ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).ability(AbilityTooltip.builder().arg(((Stats)this.stats).teleportDistance).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (!(entity instanceof HorseEntity)) {
            return ActionResultType.FAIL;
        }
        HorseEntity horse = (HorseEntity)entity;
        CompoundNBT nbt = stack.func_179543_a(TAG_ENTITY);
        if (nbt != null) {
            this.releaseHorse(stack, (Entity)player);
            this.catchHorse(horse, (Entity)player, stack);
            return ActionResultType.SUCCESS;
        }
        this.catchHorse(horse, (Entity)player, stack);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        CompoundNBT nbt = stack.func_179543_a(TAG_ENTITY);
        if (player == null) {
            return ActionResultType.FAIL;
        }
        if (nbt == null) {
            if (player.func_225608_bj_()) {
                NBTUtils.setString(stack, TAG_UUID, "");
            } else {
                this.catchHorse(stack, (Entity)player);
            }
            return ActionResultType.SUCCESS;
        }
        this.releaseHorse(stack, (Entity)player);
        if (player.func_225608_bj_()) {
            NBTUtils.setString(stack, TAG_UUID, "");
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        CompoundNBT nbt = stack.func_179543_a(TAG_ENTITY);
        if (nbt == null) {
            if (player.func_225608_bj_()) {
                NBTUtils.setString(stack, TAG_UUID, "");
            } else {
                this.catchHorse(stack, (Entity)player);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        this.releaseHorse(stack, (Entity)player);
        if (player.func_225608_bj_()) {
            NBTUtils.setString(stack, TAG_UUID, "");
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        HorseEntity horse = this.findHorse(worldIn, stack);
        if (horse == null || entityIn.func_70032_d((Entity)horse) < (float)((Stats)this.stats).teleportDistance) {
            return;
        }
        this.catchHorse(horse, entityIn, stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    private HorseEntity findHorse(World world, ItemStack stack) {
        if (world.func_201670_d()) {
            return null;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        String uuid = NBTUtils.getString(stack, TAG_UUID, "");
        if (uuid.equals("")) {
            return null;
        }
        Entity entity = serverWorld.func_217461_a(UUID.fromString(uuid));
        return entity instanceof HorseEntity ? (HorseEntity)entity : null;
    }

    private void catchHorse(HorseEntity horse, Entity player, ItemStack stack) {
        if (horse.func_233643_dh_() || horse.func_184780_dh() == null || !horse.func_184780_dh().equals(player.func_110124_au())) {
            return;
        }
        World world = horse.func_130014_f_();
        CompoundNBT nbt = new CompoundNBT();
        Vector3d pos = horse.func_213303_ch();
        horse.func_189511_e(nbt);
        stack.func_77983_a(TAG_ENTITY, (INBT)nbt);
        NBTUtils.setString(stack, TAG_UUID, "");
        horse.func_70106_y();
        if (!world.func_201670_d()) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197627_t, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.func_184133_a(null, horse.func_233580_cy_(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    private void catchHorse(ItemStack stack, Entity player) {
        World world = player.func_130014_f_();
        HorseEntity horse = this.findHorse(world, stack);
        if (horse != null) {
            this.catchHorse(horse, player, stack);
        }
    }

    private void releaseHorse(ItemStack stack, Entity player) {
        World world = player.func_130014_f_();
        HorseEntity horse = new HorseEntity(EntityType.field_200762_B, world);
        Vector3d pos = player.func_213303_ch();
        CompoundNBT data = stack.func_179543_a(TAG_ENTITY);
        if (data != null) {
            horse.func_70020_e(data);
        }
        horse.func_70107_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        world.func_217376_c((Entity)horse);
        horse.func_213317_d(player.func_70676_i(1.0f).func_72432_b());
        horse.field_70143_R = 0.0f;
        stack.func_77982_d(new CompoundNBT());
        NBTUtils.setString(stack, TAG_UUID, horse.func_110124_au().toString());
        if (!world.func_201670_d()) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197627_t, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.func_184133_a(null, horse.func_233580_cy_(), SoundEvents.field_226132_ag_, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_179543_a(TAG_ENTITY) != null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public static class Stats
    extends RelicStats {
        public int teleportDistance = 16;
    }
}

