/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.curios.api.SlotContext;

public class MagicMirrorItem
extends RelicItem<Stats> {
    public MagicMirrorItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#008cd7", "#0a3484").ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_184811_cZ().func_185141_a((Item)ItemRegistry.MAGIC_MIRROR.get()) || DurabilityUtils.isBroken(stack) || worldIn.func_201670_d()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerIn;
        BlockPos pos = serverPlayer.func_241140_K_();
        float angle = serverPlayer.func_242109_L();
        ServerWorld world = serverPlayer.func_184102_h().func_71218_a(serverPlayer.func_241141_L_());
        TranslationTextComponent message = new TranslationTextComponent("tooltip.relics.magic_mirror.invalid_location");
        if (pos == null || world == null) {
            playerIn.func_146105_b((ITextComponent)message, true);
            return ActionResult.func_226251_d_((Object)stack);
        }
        Optional optional = PlayerEntity.func_242374_a((ServerWorld)world, (BlockPos)pos, (float)angle, (boolean)true, (boolean)false);
        if (optional.isPresent()) {
            pos = new BlockPos((Vector3d)optional.get());
            if (playerIn.func_184187_bx() != null) {
                playerIn.func_184210_p();
            }
            serverPlayer.func_200619_a(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), playerIn.field_70177_z, playerIn.field_70125_A);
            worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_191263_gW, SoundCategory.PLAYERS, 1.0f, 1.0f);
            NetworkHandler.sendToClient(new PacketItemActivation(stack), serverPlayer);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_184811_cZ().func_185145_a((Item)ItemRegistry.MAGIC_MIRROR.get(), ((Stats)this.stats).cooldown * 20);
            }
        } else {
            playerIn.func_146105_b((ITextComponent)message, true);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public static class Stats
    extends RelicStats {
        public int cooldown = 30;
    }
}

