/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.entities.SpaceDissectorEntity;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import top.theillusivec4.curios.api.SlotContext;

public class SpaceDissectorItem
extends RelicItem<Stats> {
    public static final String TAG_IS_THROWN = "thrown";
    public static final String TAG_UUID = "uuid";
    public static final String TAG_UPDATE_TIME = "time";
    public static SpaceDissectorItem INSTANCE;

    public SpaceDissectorItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#e3dbd7", "#8a7d78").ability(AbilityTooltip.builder().arg(((Stats)this.stats).maxBounces).arg(((Stats)this.stats).baseDamage).arg((int)(((Stats)this.stats).damageMultiplierPerBounce * 100.0f - 100.0f) + "%").active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).ability(AbilityTooltip.builder().arg(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_237520_d_().getString()).active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (DurabilityUtils.isBroken(stack) || playerIn.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!NBTUtils.getBoolean(stack, TAG_IS_THROWN, false)) {
            SpaceDissectorEntity entity = new SpaceDissectorEntity(worldIn, (LivingEntity)playerIn);
            NBTUtils.setBoolean(stack, TAG_IS_THROWN, true);
            NBTUtils.setString(stack, TAG_UUID, entity.func_110124_au().toString());
            NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
            entity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 1.0f, ((Stats)this.stats).projectileSpeed, 0.0f);
            entity.stack = playerIn.func_184586_b(handIn);
            entity.setOwner(playerIn);
            worldIn.func_217376_c((Entity)entity);
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundRegistry.THROW, SoundCategory.MASTER, 0.5f, 0.75f + field_77697_d.nextFloat() * 0.5f);
        } else {
            String string = NBTUtils.getString(stack, TAG_UUID, "");
            if (string.equals("")) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            UUID uuid = UUID.fromString(string);
            if (!(worldIn instanceof ServerWorld)) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            Entity entity = ((ServerWorld)worldIn).func_217461_a(uuid);
            if (entity instanceof SpaceDissectorEntity && entity.func_70089_S()) {
                SpaceDissectorEntity dissector = (SpaceDissectorEntity)entity;
                if (!playerIn.func_225608_bj_()) {
                    if (!((Boolean)dissector.func_184212_Q().func_187225_a(SpaceDissectorEntity.IS_RETURNING)).booleanValue()) {
                        dissector.func_184212_Q().func_187227_b(SpaceDissectorEntity.IS_RETURNING, (Object)true);
                    }
                } else {
                    playerIn.func_70634_a(dissector.func_226277_ct_(), dissector.func_226278_cu_(), dissector.func_226281_cx_());
                    worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).cooldownAfterTeleport * 20);
                    NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
                    dissector.func_70106_y();
                }
            } else {
                playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).cooldownAfterTeleport * 20);
                NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (DurabilityUtils.isBroken(stack) || !NBTUtils.getBoolean(stack, TAG_IS_THROWN, false) || entityIn.field_70173_aa % 20 != 0) {
            return;
        }
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
        NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
        if (time > ((Stats)this.stats).maxThrownTime) {
            NBTUtils.setBoolean(stack, TAG_IS_THROWN, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static class Stats
    extends RelicStats {
        public float projectileSpeed = 1.0f;
        public int maxThrownTime = 60;
        public int timeBeforeReturn = 10;
        public int cooldownAfterTeleport = 10;
        public int maxBounces = 10;
        public int additionalTimeAfterBounce = 4;
        public int baseDamage = 8;
        public float damageMultiplierPerBounce = 1.5f;
    }
}

