/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.renderer.items.models.ElytraBoosterModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ElytraBoosterItem
extends RelicItem<Stats>
implements ICurioItem {
    public static final String TAG_BREATH_AMOUNT = "breath";

    public ElytraBoosterItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#b8b8d6", "#6e6e8f").ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_228046_af_).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int breath = NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0);
        if (breath > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.elytra_booster.tooltip_1", new Object[]{breath}));
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        if (player.func_184613_cA()) {
            this.accelerate(player, stack);
        } else {
            this.collectBreath(player, stack);
        }
    }

    private void accelerate(PlayerEntity player, ItemStack stack) {
        int breath = NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0);
        if (!player.func_225608_bj_() || breath <= 0) {
            return;
        }
        Vector3d look = player.func_70040_Z();
        Vector3d motion = player.func_213322_ci();
        World world = player.func_130014_f_();
        Random random = world.func_201674_k();
        player.func_213317_d(motion.func_72441_c(look.field_72450_a * 0.1 + (look.field_72450_a * (double)((Stats)this.stats).flySpeed - motion.field_72450_a) * 0.5, look.field_72448_b * 0.1 + (look.field_72448_b * (double)((Stats)this.stats).flySpeed - motion.field_72448_b) * 0.5, look.field_72449_c * 0.1 + (look.field_72449_c * (double)((Stats)this.stats).flySpeed - motion.field_72449_c) * 0.5));
        world.func_195594_a((IParticleData)ParticleTypes.field_197616_i, player.func_226277_ct_() + (double)(MathUtils.randomFloat(random) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(random) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(random) * 0.5f), 0.0, 0.0, 0.0);
        if (player.field_70173_aa % 10 == 0) {
            NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath - 1);
        }
    }

    private void collectBreath(PlayerEntity player, ItemStack stack) {
        World world = player.func_130014_f_();
        int breath = NBTUtils.getInt(stack, TAG_BREATH_AMOUNT, 0);
        if (breath >= ((Stats)this.stats).breathCapacity) {
            return;
        }
        if (world.func_234923_W_() == World.field_234920_i_ && player.field_70173_aa % (((Stats)this.stats).breathRegenerationCooldown * 20) == 0) {
            NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath + 1);
        }
        for (AreaEffectCloudEntity cloud : world.func_217357_a(AreaEffectCloudEntity.class, player.func_174813_aQ().func_186662_g((double)((Stats)this.stats).breathConsumptionRadius))) {
            if (cloud.func_195058_l() != ParticleTypes.field_197616_i) continue;
            if (player.field_70173_aa % 5 == 0) {
                NBTUtils.setInt(stack, TAG_BREATH_AMOUNT, breath + 1);
            }
            if (cloud.func_184490_j() <= 0.0f) {
                cloud.func_70106_y();
            }
            cloud.func_184483_a(cloud.func_184490_j() - ((Stats)this.stats).breathConsumptionSpeed);
            Vector3d direction = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(cloud.func_213303_ch()).func_72432_b();
            double distance = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_72438_d(cloud.func_213303_ch());
            world.func_195594_a((IParticleData)new CircleTintData(new Color(160, 0, 255), (float)(distance * (double)0.075f), (int)distance * 5, 0.95f, false), cloud.func_226277_ct_(), cloud.func_226278_cu_(), cloud.func_226281_cx_(), direction.field_72450_a * (double)0.2f, direction.field_72448_b * (double)0.2f, direction.field_72449_c * (double)0.2f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new ElytraBoosterModel();
    }

    public static class Stats
    extends RelicStats {
        public float flySpeed = 1.5f;
        public int breathConsumptionRadius = 10;
        public int breathCapacity = 1000;
        public float breathConsumptionSpeed = 0.02f;
        public int breathRegenerationCooldown = 2;
    }
}

