/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import it.hurts.sskirillss.relics.client.renderer.items.models.DrownedBeltModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class DrownedBeltItem
extends RelicItem<Stats> {
    public static DrownedBeltItem INSTANCE;

    public DrownedBeltItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#7889b8", "#25374e").ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).dealtDamageMultiplier * 100.0f - 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).incomingDamageMultiplier * 100.0f - 100.0f) + "%").negative().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    @Override
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().entry((Pair<String, Integer>)Pair.of((Object)"talisman", (Object)1)).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new DrownedBeltModel();
    }

    public static class Stats
    extends RelicStats {
        public float incomingDamageMultiplier = 1.5f;
        public float dealtDamageMultiplier = 2.0f;
        public int riptideCooldown = 10;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class DrownedBeltServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            PlayerEntity player = null;
            float value = 1.0f;
            if (event.getEntityLiving() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getEntityLiving();
                value = stats.incomingDamageMultiplier;
            } else if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                player = (PlayerEntity)event.getSource().func_76346_g();
                value = stats.dealtDamageMultiplier;
            }
            if (player != null && player.func_204231_K() && !EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get()).func_190926_b()) {
                event.setAmount(event.getAmount() * value);
            }
        }

        @SubscribeEvent
        public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
            ItemStack stack = event.getItem();
            if (!(event.getEntityLiving() instanceof PlayerEntity) || stack.func_77973_b() != Items.field_203184_eO) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onItemUseFinish(LivingEntityUseItemEvent.Stop event) {
            Stats stats = (Stats)INSTANCE.stats;
            ItemStack stack = event.getItem();
            if (!(event.getEntityLiving() instanceof PlayerEntity) || stack.func_77973_b() != Items.field_203184_eO) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.DROWNED_BELT.get()).func_190926_b()) {
                return;
            }
            int duration = stack.func_77973_b().func_77626_a(stack) - event.getDuration();
            int enchantment = EnchantmentHelper.func_203190_g((ItemStack)stack);
            if (duration < 10 || enchantment <= 0) {
                return;
            }
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), stats.riptideCooldown / (enchantment + 1) * 20);
        }
    }
}

