/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.client.renderer.items.models.IceBreakerModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class IceBreakerItem
extends RelicItem<Stats> {
    public static IceBreakerItem INSTANCE;

    public IceBreakerItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#6098f4", "#16418a").ability(AbilityTooltip.builder().negative().arg("-" + (int)Math.abs(((Stats)this.stats).speedModifier * 100.0f) + "%").arg("+" + (int)((((Stats)this.stats).fallMotionMultiplier - 1.0f) * 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).knockbackResistanceModifier * 100.0f) + "%").build()).ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_228046_af_).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    @Override
    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.field_233821_d_, ((Stats)this.stats).speedModifier)).attribute(new RelicAttributeModifier.Modifier(Attributes.field_233820_c_, ((Stats)this.stats).knockbackResistanceModifier)).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        Vector3d motion = player.func_213322_ci();
        if (player.func_233570_aj_() || player.field_71075_bZ.field_75100_b || motion.func_82617_b() > 0.0 || player.func_184613_cA() || player.func_175149_v()) {
            return;
        }
        player.func_213293_j(motion.func_82615_a(), motion.func_82617_b() * (double)((Stats)this.stats).fallMotionMultiplier, motion.func_82616_c());
        player.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new IceBreakerModel();
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = -0.1f;
        public float knockbackResistanceModifier = 0.5f;
        public float fallMotionMultiplier = 1.075f;
        public float stompCooldownMultiplier = 1.5f;
        public float stompRadiusMultiplier = 0.5f;
        public float stompMotionMultiplier = 1.005f;
        public float dealtDamageMultiplier = 1.0f;
        public int maxDealtDamage = 100;
        public float incomingFallDamageMultiplier = 0.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class IceBreakerServerEvents {
        @SubscribeEvent
        public static void onEntityFall(LivingFallEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ICE_BREAKER.get()).func_190926_b()) {
                return;
            }
            float distance = event.getDistance();
            World world = player.func_130014_f_();
            if (distance < 2.0f || !player.func_225608_bj_()) {
                return;
            }
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187926_gz, SoundCategory.PLAYERS, 0.75f, 1.0f);
            world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            player.func_184811_cZ().func_185145_a((Item)ItemRegistry.ICE_BREAKER.get(), Math.round(distance * stats.stompCooldownMultiplier * 20.0f));
            for (LivingEntity entity : world.func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g((double)(distance * stats.stompRadiusMultiplier)))) {
                if (entity == player) continue;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), Math.min((float)stats.maxDealtDamage, distance * stats.dealtDamageMultiplier));
                entity.func_213317_d(entity.func_213303_ch().func_178788_d(player.func_213303_ch()).func_72441_c(0.0, (double)1.005f, 0.0).func_216372_d((double)stats.stompMotionMultiplier, (double)stats.stompMotionMultiplier, (double)stats.stompMotionMultiplier));
            }
            event.setDamageMultiplier(stats.incomingFallDamageMultiplier);
        }
    }
}

