/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.client.renderer.items.models.IceSkatesModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.SlotContext;

public class IceSkatesItem
extends RelicItem<Stats> {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:ice_skates_movement_speed", (Object)UUID.fromString("c0f5890f-a878-49bb-b24c-bbbf60d8539b"));
    public static IceSkatesItem INSTANCE;

    public IceSkatesItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#7ba3e0", "#477d91").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).speedModifier * 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg((int)((Stats)this.stats).ramDamage).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        World world = livingEntity.func_130014_f_();
        BlockPos pos = WorldUtils.getSolidBlockUnderFeet(world, livingEntity.func_233580_cy_());
        if (pos == null || DurabilityUtils.isBroken(stack)) {
            return;
        }
        if (world.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_205213_E)) {
            EntityUtils.applyAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            if (livingEntity.func_70051_ag()) {
                if (livingEntity.func_233570_aj_()) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197602_M, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + (double)0.1f, livingEntity.func_226281_cx_(), 0.0, (double)0.2f, 0.0);
                }
                for (LivingEntity entity : world.func_217357_a(LivingEntity.class, livingEntity.func_174813_aQ().func_186662_g((double)((Stats)this.stats).ramRadius))) {
                    if (entity == livingEntity || entity.field_70172_ad > 0) continue;
                    entity.func_213317_d(entity.func_213303_ch().func_178788_d(livingEntity.func_213303_ch()).func_72432_b().func_216372_d(0.25, (double)0.1f, 0.25));
                    world.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_203255_y, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    entity.func_70097_a(DamageSource.field_188406_j, ((Stats)this.stats).ramDamage);
                }
            }
        } else {
            EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new IceSkatesModel();
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 1.1f;
        public float ramRadius = 0.5f;
        public float ramDamage = 5.0f;
        public float fallingDamageMultiplier = 0.25f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class IceSkatesEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getEntityLiving() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ICE_SKATES.get()).func_190926_b() && player.func_130014_f_().func_180495_p(player.func_233580_cy_().func_177977_b()).func_235714_a_((ITag)BlockTags.field_205213_E) && event.getSource() == DamageSource.field_76379_h) {
                event.setAmount(event.getAmount() * stats.fallingDamageMultiplier);
            }
        }
    }
}

