/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.blocks.MagmaStoneBlock;
import it.hurts.sskirillss.relics.client.renderer.items.models.MagmaWalkerModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class MagmaWalkerItem
extends RelicItem<RelicStats> {
    public MagmaWalkerItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#ff6900", "#ff2e00").ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().build()).build();
    }

    @Override
    public RelicConfigData<RelicStats> getConfigData() {
        return RelicConfigData.builder().build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        BlockPos pos = livingEntity.func_233580_cy_();
        BlockState state = world.func_180495_p(pos.func_177977_b());
        FluidState fluid = state.func_204520_s();
        if (DurabilityUtils.isBroken(stack) || livingEntity.func_175149_v()) {
            return;
        }
        if (fluid.func_206886_c() == Fluids.field_204547_b || fluid.func_206886_c() == Fluids.field_207213_d) {
            world.func_175656_a(pos.func_177977_b(), (BlockState)((BlockState)((MagmaStoneBlock)BlockRegistry.MAGMA_STONE_BLOCK.get()).func_176223_P().func_206870_a((Property)MagmaStoneBlock.LEVEL, (Comparable)(fluid.func_206889_d() ? Integer.valueOf(0) : (Integer)fluid.func_177229_b((Property)FlowingFluid.field_207210_b)))).func_206870_a((Property)MagmaStoneBlock.FALLING, (Comparable)Boolean.valueOf(!fluid.func_206889_d() && (Boolean)fluid.func_177229_b((Property)FlowingFluid.field_207209_a) != false)));
            world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), 1.0, 1.0, 1.0);
            world.func_184133_a(null, livingEntity.func_233580_cy_(), SoundEvents.field_232689_am_, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (state.func_177230_c() == BlockRegistry.MAGMA_STONE_BLOCK.get() && (Integer)state.func_177229_b((Property)MagmaStoneBlock.AGE) > 0) {
            world.func_180501_a(pos.func_177977_b(), ((MagmaStoneBlock)BlockRegistry.MAGMA_STONE_BLOCK.get()).func_176223_P(), 2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new MagmaWalkerModel();
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class MagmaWalkerServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            if (!EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.MAGMA_WALKER.get()).func_190926_b() && event.getSource() == DamageSource.field_190095_e) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            if (!EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.MAGMA_WALKER.get()).func_190926_b() && event.getSource() == DamageSource.field_190095_e) {
                event.setCanceled(true);
            }
        }
    }
}

