/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.client.renderer.items.models.OutRunnerModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.SlotContext;

public class OutRunnerItem
extends RelicItem<Stats> {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:out_runner_movement_speed", (Object)UUID.fromString("9bf3eeb5-8587-4fb7-ad81-fd76e01f4acf"));
    private static final String TAG_RUN_DURATION = "duration";

    public OutRunnerItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#50d8a5", "#1f9367").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).speedModifier * 100.0f * 5.0f) + "%").build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        World world = player.func_130014_f_();
        ModifiableAttributeInstance movementSpeed = player.func_110148_a(Attributes.field_233821_d_);
        int duration = NBTUtils.getInt(stack, TAG_RUN_DURATION, 0);
        if (player.func_70051_ag() && !player.func_225608_bj_() && !player.func_70090_H() && !player.func_180799_ab()) {
            if (duration < ((Stats)this.stats).maxModifiers && player.field_70173_aa % 4 == 0) {
                NBTUtils.setInt(stack, TAG_RUN_DURATION, duration + 1);
            }
            if (world.func_201674_k().nextInt(((Stats)this.stats).maxModifiers) < duration) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, player.func_226277_ct_(), player.func_226278_cu_() + (double)0.15f, player.func_226281_cx_(), 0.0, 0.25, 0.0);
            }
        } else if (duration > 0) {
            NBTUtils.setInt(stack, TAG_RUN_DURATION, duration - 1);
        }
        if (duration > 0) {
            EntityUtils.removeAttributeModifier(Objects.requireNonNull(movementSpeed), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), movementSpeed.func_111126_e(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            EntityUtils.applyAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((float)duration * ((Stats)this.stats).speedModifier), AttributeModifier.Operation.MULTIPLY_TOTAL));
            player.field_70138_W = 1.1f;
        } else {
            EntityUtils.removeAttributeModifier(Objects.requireNonNull(movementSpeed), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            player.field_70138_W = 0.6f;
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.func_77973_b() == newStack.func_77973_b()) {
            return;
        }
        LivingEntity entity = slotContext.getWearer();
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(entity.func_110148_a(Attributes.field_233821_d_)), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        entity.field_70138_W = 0.6f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new OutRunnerModel();
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 0.01f;
        public int maxModifiers = 125;
    }
}

