/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.head;

import it.hurts.sskirillss.relics.client.particles.spark.SparkTintData;
import it.hurts.sskirillss.relics.client.renderer.items.models.FragrantFlowerModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

public class FragrantFlowerItem
extends RelicItem<Stats> {
    public static FragrantFlowerItem INSTANCE;

    public FragrantFlowerItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#f95aa7", "#910d61").ability(AbilityTooltip.builder().arg(((Stats)this.stats).luringRadius).build()).ability(AbilityTooltip.builder().arg(Float.valueOf(((Stats)this.stats).healingMultiplier)).arg(((Stats)this.stats).luringRadius).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        World world = player.func_130014_f_();
        if (player.field_70173_aa % 5 != 0) {
            return;
        }
        List bees = world.func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)((Stats)this.stats).luringRadius, (double)((Stats)this.stats).luringRadius, (double)((Stats)this.stats).luringRadius));
        if (!bees.isEmpty() && world.func_201670_d()) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curios -> curios.getStacksHandler(identifier).map(handler -> {
                if (!handler.getStacks().getStackInSlot(index).func_190926_b() && ((Boolean)handler.getRenders().get(index)).booleanValue()) {
                    world.func_195594_a((IParticleData)new SparkTintData(new Color(255, 255 - field_77697_d.nextInt(50), 0), 0.2f, 30), player.func_213303_ch().func_82615_a(), player.func_226280_cw_() + 0.25, player.func_213303_ch().func_82616_c(), (double)(MathUtils.randomFloat(field_77697_d) * 0.01f), 0.0, (double)(MathUtils.randomFloat(field_77697_d) * 0.01f));
                }
                return true;
            }).orElse(false));
        }
        for (BeeEntity bee : bees) {
            if (bee.func_230257_G__() == null || !bee.func_230257_G__().equals(player.func_110124_au())) continue;
            bee.func_70604_c(null);
            bee.func_230259_a_(null);
            bee.func_70624_b(null);
            bee.func_230260_a__(0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new FragrantFlowerModel();
    }

    public static class Stats
    extends RelicStats {
        public int luringRadius = 16;
        public float damageMultiplier = 3.0f;
        public float healingMultiplier = 0.5f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class FragrantFlowerServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            block8: {
                Stats stats;
                block9: {
                    block7: {
                        stats = (Stats)INSTANCE.stats;
                        if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) break block7;
                        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                        LivingEntity target = event.getEntityLiving();
                        if (target instanceof BeeEntity) {
                            return;
                        }
                        if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.FRAGRANT_FLOWER.get()).func_190926_b()) {
                            return;
                        }
                        for (BeeEntity bee : player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)stats.luringRadius, (double)stats.luringRadius, (double)stats.luringRadius))) {
                            bee.func_70604_c(target);
                            bee.func_230259_a_(target.func_110124_au());
                            bee.func_70624_b(target);
                            bee.func_230260_a__(TickRangeConverter.func_233037_a_((int)20, (int)39).func_233018_a_(bee.func_130014_f_().func_201674_k()));
                        }
                        break block8;
                    }
                    if (!(event.getSource().func_76346_g() instanceof BeeEntity)) break block9;
                    BeeEntity bee = (BeeEntity)event.getSource().func_76346_g();
                    for (PlayerEntity player : bee.func_130014_f_().func_217357_a(PlayerEntity.class, bee.func_174813_aQ().func_72314_b((double)stats.luringRadius, (double)stats.luringRadius, (double)stats.luringRadius))) {
                        if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.FRAGRANT_FLOWER.get()).func_190926_b()) continue;
                        event.setAmount(event.getAmount() * stats.damageMultiplier);
                    }
                    break block8;
                }
                if (!(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity)) break block8;
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
                if (source instanceof BeeEntity) {
                    return;
                }
                if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.FRAGRANT_FLOWER.get()).func_190926_b()) {
                    return;
                }
                for (BeeEntity bee : player.func_130014_f_().func_217357_a(BeeEntity.class, player.func_174813_aQ().func_72314_b((double)stats.luringRadius, (double)stats.luringRadius, (double)stats.luringRadius))) {
                    if (bee.func_230257_G__() != null) continue;
                    bee.func_70604_c(source);
                    bee.func_230259_a_(source.func_110124_au());
                    bee.func_70624_b(source);
                    bee.func_230260_a__(TickRangeConverter.func_233037_a_((int)20, (int)39).func_233018_a_(bee.func_130014_f_().func_201674_k()));
                }
            }
        }

        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            LivingEntity entity = event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.FRAGRANT_FLOWER.get()).func_190926_b()) {
                return;
            }
            List bees = entity.func_130014_f_().func_217357_a(BeeEntity.class, entity.func_174813_aQ().func_72314_b((double)stats.luringRadius, (double)stats.luringRadius, (double)stats.luringRadius));
            if (bees.isEmpty()) {
                return;
            }
            event.setAmount(event.getAmount() + event.getAmount() * ((float)bees.size() * stats.healingMultiplier));
        }
    }
}

