/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.client.renderer.items.models.HolyLocketModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class HolyLocketItem
extends RelicItem<Stats> {
    private static final String TAG_IS_ACTIVE = "active";
    public static HolyLocketItem INSTANCE;

    public HolyLocketItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#ff6800", "#0087ff").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).damageMultiplier * 100.0f - 100.0f) + "%").arg((int)(((Stats)this.stats).igniteChance * 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).healMultiplier * 100.0f - 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg(Float.valueOf((float)((Stats)this.stats).invulnerabilityTime / 20.0f)).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (DurabilityUtils.isBroken(stack)) {
            return;
        }
        if (livingEntity.field_70172_ad <= 10) {
            NBTUtils.setBoolean(stack, TAG_IS_ACTIVE, true);
        } else if (NBTUtils.getBoolean(stack, TAG_IS_ACTIVE, false)) {
            livingEntity.field_70172_ad += ((Stats)this.stats).invulnerabilityTime;
            NBTUtils.setBoolean(stack, TAG_IS_ACTIVE, false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new HolyLocketModel();
    }

    public static class Stats
    extends RelicStats {
        public float damageMultiplier = 1.5f;
        public float healMultiplier = 1.25f;
        public float igniteChance = 0.25f;
        public int invulnerabilityTime = 10;
    }

    @Mod.EventBusSubscriber
    static class HolyLocketEvents {
        HolyLocketEvents() {
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            Entity source = event.getSource().func_76346_g();
            if (!(source instanceof PlayerEntity)) {
                return;
            }
            LivingEntity entity = event.getEntityLiving();
            if (!entity.func_70662_br()) {
                return;
            }
            if (EntityUtils.findEquippedCurio((Entity)((PlayerEntity)source), (Item)ItemRegistry.HOLY_LOCKET.get()).func_190926_b()) {
                return;
            }
            if (field_77697_d.nextFloat() <= stats.igniteChance) {
                entity.func_70015_d(4);
            }
            event.setAmount(event.getAmount() * stats.damageMultiplier);
        }

        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.HOLY_LOCKET.get()).func_190926_b()) {
                return;
            }
            event.setAmount(event.getAmount() * stats.healMultiplier);
        }
    }
}

