/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.ring;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.block.BushBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CamouflageRingItem
extends RelicItem<RelicStats> {
    public CamouflageRingItem() {
        super(RelicData.builder().rarity(Rarity.UNCOMMON).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#009122", "#002816").ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_228046_af_).build()).build();
    }

    @Override
    public RelicConfigData<RelicStats> getConfigData() {
        return RelicConfigData.builder().build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 == 0 && CamouflageRingItem.canHide(livingEntity)) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76441_p, 30, 0, false, false));
        }
    }

    private static boolean canHide(LivingEntity entity) {
        return !EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.CAMOUFLAGE_RING.get()).func_190926_b() && entity.func_225608_bj_() && entity.func_130014_f_().func_180495_p(entity.func_233580_cy_()).func_177230_c() instanceof BushBlock;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class CamouflageRingClientEvents {
        @SubscribeEvent
        public static void onEntityRender(RenderPlayerEvent.Pre event) {
            if (CamouflageRingItem.canHide((LivingEntity)event.getPlayer())) {
                event.setCanceled(true);
            }
        }
    }
}

