/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class ScarabTalismanItem
extends RelicItem<Stats> {
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:scarab_talisman_movement_speed", (Object)UUID.fromString("09bc5b60-3277-45ee-8bf0-aae7acba4385"));
    public static ScarabTalismanItem INSTANCE;

    public ScarabTalismanItem() {
        super(RelicData.builder().rarity(Rarity.RARE).hasAbility().build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#fcc100", "#fca900").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).speedModifier * 100.0f - 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).digModifier * 100.0f - 100.0f) + "%").build()).ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().active().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        World world = livingEntity.func_130014_f_();
        if (DurabilityUtils.isBroken(stack)) {
            return;
        }
        if (((Stats)this.stats).allowedBiomes.stream().map(Biome.Category::func_235103_a_).collect(Collectors.toList()).contains(world.func_226691_t_(livingEntity.func_233580_cy_()).func_201856_r())) {
            EntityUtils.applyAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else {
            EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        ModifiableAttributeInstance movementSpeed = slotContext.getWearer().func_110148_a(Attributes.field_233821_d_);
        EntityUtils.removeAttributeModifier(movementSpeed, new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    public void castAbility(PlayerEntity player, ItemStack stack) {
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return;
        }
        World world = player.func_130014_f_();
        BlockPos position = player.func_233580_cy_();
        Vector3d vec = player.func_213303_ch();
        BlockPos target = position;
        Vector3d ground = vec;
        boolean canTeleport = false;
        if (this.isEmptySpot(world, position) && this.isEmptySpot(world, position.func_177984_a())) {
            vec = vec.func_72441_c(0.0, -2.0, 0.0);
            if (!(this.isEmptySpot(world, target = target.func_177979_c(3)) || this.isEmptySpot(world, target.func_177984_a()) || this.isEmptySpot(world, target.func_177984_a()))) {
                canTeleport = true;
            }
        } else if (!this.isEmptySpot(world, position) && !this.isEmptySpot(world, position.func_177984_a())) {
            vec = vec.func_72441_c(0.0, 2.0, 0.0);
            ground = ground.func_72441_c(0.0, 2.0, 0.0);
            if (this.isEmptySpot(world, target = target.func_177981_b(2)) && this.isEmptySpot(world, target.func_177984_a())) {
                canTeleport = true;
            }
        }
        if (canTeleport) {
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).burrowCooldown * 20);
            player.func_70634_a(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
            for (int i = 0; i < 100; ++i) {
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, world.func_180495_p(position.func_177977_b())), ground.func_82615_a() + (double)(MathUtils.randomFloat(field_77697_d) * 0.5f), ground.func_82617_b() + (double)0.2f, ground.func_82616_c() + (double)(MathUtils.randomFloat(field_77697_d) * 0.5f), 0.0, (double)field_77697_d.nextFloat(), 0.0);
            }
            world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_232687_ak_, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean isEmptySpot(World world, BlockPos position) {
        return !world.func_180495_p(position).func_185904_a().func_76230_c();
    }

    public static class Stats
    extends RelicStats {
        public int burrowCooldown = 3;
        public float speedModifier = 1.15f;
        public float digModifier = 1.1f;
        public List<String> allowedBiomes = Arrays.asList("mesa", "desert");
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class ScarabTalismanServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.SCARAB_TALISMAN.get()).func_190926_b() || event.getSource() != DamageSource.field_76368_d) {
                return;
            }
            entity.func_195064_c(new EffectInstance(Effects.field_76441_p, 20, 0, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 20, 0, false, false));
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onEntityAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.SCARAB_TALISMAN.get()).func_190926_b() || event.getSource() != DamageSource.field_76368_d) {
                return;
            }
            entity.func_195064_c(new EffectInstance(Effects.field_76441_p, 30, 0, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 30, 0, false, false));
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onBlockBreakCalculate(PlayerEvent.BreakSpeed event) {
            Stats stats = (Stats)INSTANCE.stats;
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.SCARAB_TALISMAN.get(), event.getEntityLiving()).ifPresent(triple -> {
                if (DurabilityUtils.isBroken((ItemStack)triple.getRight())) {
                    return;
                }
                event.setNewSpeed(event.getNewSpeed() * stats.digModifier);
            });
        }
    }
}

