/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SlimeHeartItem
extends RelicItem<Stats> {
    public static SlimeHeartItem INSTANCE;

    public SlimeHeartItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#73c262", "#40a31c").ability(AbilityTooltip.builder().arg((int)(((Stats)this.stats).healingMultiplier * 100.0f - 100.0f) + "%").negative().build()).ability(AbilityTooltip.builder().arg(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_237520_d_().getString()).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public static class Stats
    extends RelicStats {
        public float motionMultiplier = 0.9f;
        public float healingMultiplier = 0.75f;
    }

    public static class BounceHandler
    implements Consumer<LivingEvent.LivingUpdateEvent> {
        private static final IdentityHashMap<Entity, BounceHandler> bouncingEntities = new IdentityHashMap();
        public final LivingEntity entity;
        private boolean wasInAir;
        private double delta;
        private int time;
        private int tick;

        public BounceHandler(LivingEntity entityLiving, double motion) {
            this.entity = entityLiving;
            this.wasInAir = false;
            this.delta = motion;
            this.time = 0;
            this.tick = motion != 0.0 ? entityLiving.field_70173_aa + 1 : 0;
            bouncingEntities.put((Entity)entityLiving, this);
        }

        @Override
        public void accept(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() != this.entity || this.entity.func_184613_cA()) {
                return;
            }
            if (this.entity.field_70173_aa == this.tick) {
                Vector3d motion = this.entity.func_213322_ci();
                this.entity.func_213293_j(motion.field_72450_a, this.delta, motion.field_72449_c);
                this.tick = 0;
            }
            if (this.wasInAir && this.entity.func_233570_aj_()) {
                if (this.time == 0) {
                    this.time = this.entity.field_70173_aa;
                } else if (this.entity.field_70173_aa - this.time > 5) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    bouncingEntities.remove(this.entity);
                }
            } else {
                this.time = 0;
                this.wasInAir = true;
            }
        }

        public static void addBounceHandler(LivingEntity entity, double bounce) {
            if (entity instanceof FakePlayer) {
                return;
            }
            BounceHandler handler = bouncingEntities.get(entity);
            if (handler == null) {
                MinecraftForge.EVENT_BUS.addListener((Consumer)new BounceHandler(entity, bounce));
            } else if (bounce != 0.0) {
                handler.delta = bounce;
                handler.tick = entity.field_70173_aa + 1;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SlimeHeartEvents {
        @SubscribeEvent
        public static void onEntityHeal(LivingHealEvent event) {
            Stats stats = (Stats)INSTANCE.getStats();
            LivingEntity entity = event.getEntityLiving();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.SLIME_HEART.get());
            if (stack.func_190926_b()) {
                return;
            }
            event.setAmount(event.getAmount() * stats.healingMultiplier);
        }

        @SubscribeEvent
        public static void onEntityFall(LivingFallEvent event) {
            Stats stats = (Stats)INSTANCE.getStats();
            LivingEntity entity = event.getEntityLiving();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.SLIME_HEART.get());
            if (stack.func_190926_b() || event.getDistance() < 2.0f || entity.func_225608_bj_()) {
                return;
            }
            entity.field_70143_R = 0.0f;
            event.setCanceled(true);
            entity.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
            BounceHandler.addBounceHandler(entity, -entity.func_213322_ci().func_82617_b() * (double)stats.motionMultiplier);
        }
    }
}

